/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.items;

import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.attribute.Action;
import com.projectkorra.items.utils.AttributeUtils;
import com.projectkorra.projectkorra.BendingPlayer;
import com.projectkorra.projectkorra.Element;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class Glider {
    public Glider(Player p) {
        this(p, false);
    }

    public Glider(Player p, final boolean auto) {
        final Player player = p;
        BendingPlayer bplayer = BendingPlayer.getBendingPlayer((String)player.getName());
        if (player == null || bplayer == null) {
            return;
        }
        if (!player.isSneaking() && player.getLocation().getBlock().getType() == Material.AIR && bplayer.hasElement(Element.AIR)) {
            new BukkitRunnable(){
                int counter = 0;

                public void run() {
                    Block block = player.getLocation().add(0.0, -0.5, 0.0).getBlock();
                    if (block.getType() != Material.AIR) {
                        this.cancel();
                        return;
                    }
                    ConcurrentHashMap<String, Double> attribs = AttributeUtils.getSimplePlayerAttributeMap(player);
                    if (!player.isSneaking() && !auto || player.isSneaking() && auto) {
                        this.cancel();
                        return;
                    }
                    if (attribs.containsKey("AirGlide")) {
                        double speed = 0.6;
                        double fallSpeed = -0.12;
                        if (attribs.containsKey("AirGlideSpeed")) {
                            speed += speed * attribs.get("AirGlideSpeed") / 100.0;
                        }
                        if (attribs.containsKey("AirGlideFallSpeed")) {
                            fallSpeed += fallSpeed * attribs.get("AirGlideFallSpeed") / 100.0;
                        }
                        Location loc = player.getEyeLocation();
                        loc.setPitch(0.0f);
                        Vector vel = loc.getDirection();
                        vel.normalize();
                        vel.multiply(speed);
                        vel.setY(fallSpeed);
                        player.setFallDistance(0.0f);
                        player.setVelocity(vel);
                        if (this.counter == 0) {
                            AttributeUtils.decreaseCharges(player, Action.SHIFT);
                        }
                        ++this.counter;
                    }
                }
            }.runTaskTimer((Plugin)ProjectKorraItems.plugin, 1L, 1L);
        }
    }
}

