/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.customs;

import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.customs.PKItem;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;

public class RecipeIngredient {
    private String customItemName;
    private Material material;
    private int quantity;
    private short damage;
    private boolean isCustomItem;

    private RecipeIngredient(String customItemName, Material material, int quantity, short damage, boolean isCustomItem) {
        this.customItemName = customItemName;
        this.material = material;
        this.quantity = quantity;
        this.damage = damage;
        this.isCustomItem = isCustomItem;
    }

    public RecipeIngredient(Material material, int quantity, short damage) {
        this(null, material, quantity, damage, false);
    }

    public RecipeIngredient(String customItemName, int quantity, short damage) {
        this(customItemName, null, quantity, damage, true);
    }

    public RecipeIngredient(Material material, int quantity) {
        this(material, quantity, 0);
    }

    public RecipeIngredient(Material mat) {
        this(mat, 1);
    }

    public String getCustomItemName() {
        return this.customItemName;
    }

    public void setCustomItemName(String customItemName) {
        this.customItemName = customItemName;
    }

    public Material getMaterial() {
        return this.material;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public short getDamage() {
        return this.damage;
    }

    public void setDamage(short damage) {
        this.damage = damage;
    }

    public boolean isCustomItem() {
        return this.isCustomItem;
    }

    public void setCustomItem(boolean isCustomItem) {
        this.isCustomItem = isCustomItem;
    }

    public ItemStack getItemStack() {
        if (this.isCustomItem) {
            PKItem citem = PKItem.getCustomItem(this.customItemName);
            if (citem != null) {
                ItemStack istack = citem.generateItem();
                istack.setAmount(this.quantity);
                return istack;
            }
            ProjectKorraItems.log.severe("an error occurred while generating the custom item: " + this.customItemName);
            return new ItemStack(Material.AIR);
        }
        return new ItemStack(this.material, this.quantity, this.damage);
    }

    public String toString() {
        return "RecipeIngredient [customItemName=" + this.customItemName + ", material=" + this.material + ", quantity=" + this.quantity + ", damage=" + this.damage + ", isCustomItem=" + this.isCustomItem + "]";
    }
}

