/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.customs;

import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.attribute.AttributeList;
import com.projectkorra.items.customs.EnchantGlow;
import com.projectkorra.items.customs.RecipeIngredient;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.ChatColor;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;

public class PKItem {
    public static ConcurrentHashMap<String, PKItem> items = new ConcurrentHashMap();
    public static ArrayList<PKItem> itemList = new ArrayList();
    private String name = "";
    private String displayName = "";
    private ArrayList<String> lore = new ArrayList();
    private Material material = null;
    private int quantity = 1;
    private short damage = 0;
    private ArrayList<RecipeIngredient> recipe = new ArrayList();
    private boolean unshapedRecipe = true;
    private boolean valid = true;
    private boolean alreadyFinal;
    private boolean glow = false;
    private ArrayList<Attribute> attributes = new ArrayList();

    public void updateName(String s) {
        if (s == null || s.length() == 0 || s.contains(" ")) {
            this.valid = false;
            ProjectKorraItems.log.info("invalid name: " + this.toString());
            if (s != null) {
                this.name = s;
            }
        } else {
            this.name = s;
        }
    }

    public void updateDisplayName(String s) {
        if (s == null || s.length() == 0) {
            this.valid = false;
            ProjectKorraItems.log.info("invalid display name: " + this.toString());
        } else {
            if (!s.contains("<&")) {
                s = "<&f>" + s;
            }
            this.displayName = PKItem.colorizeString(s);
        }
    }

    public void updateLore(String s) {
        if (s == null || s.length() == 0) {
            this.valid = false;
            ProjectKorraItems.log.info("invalid lore: " + this.toString());
        } else {
            String[] lines;
            String[] stringArray = lines = s.split("<n>");
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.lore.add(PKItem.colorizeString(line));
                ++n2;
            }
        }
    }

    public void updateMaterial(String s) {
        if (s == null || s.length() == 0) {
            this.valid = false;
            ProjectKorraItems.log.info("invalid material: " + this.toString());
        } else {
            this.material = Material.getMaterial((String)s);
            if (this.material == null) {
                this.valid = false;
                ProjectKorraItems.log.info("invalid material: " + s);
            }
        }
    }

    public void updateQuantity(String s) {
        try {
            this.quantity = Integer.parseInt(s);
        }
        catch (Exception e) {
            this.valid = false;
            ProjectKorraItems.log.info("invalid amount value: " + this.toString());
        }
    }

    public void updateDamage(String s) {
        try {
            this.damage = (short)Integer.parseInt(s);
        }
        catch (Exception e) {
            this.valid = false;
            ProjectKorraItems.log.info("invalid durability value: " + this.toString());
        }
    }

    public void updateGlow(String s) {
        try {
            this.glow = Boolean.parseBoolean(s);
        }
        catch (Exception e) {
            this.valid = false;
            ProjectKorraItems.log.info("invalid glow value: " + this.toString());
        }
    }

    public void updateRecipe(String s, Set<String> customItemNames) {
        try {
            String[] commas;
            s = s.replaceAll(" ", "");
            String[] stringArray = commas = s.split(",");
            int n = commas.length;
            int n2 = 0;
            while (n2 < n) {
                String comma = stringArray[n2];
                String[] colons = comma.split(":");
                Material mat = Material.getMaterial((String)colons[0]);
                if (mat == null) {
                    try {
                        mat = Material.getMaterial((int)Integer.parseInt(colons[0]));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int quantity = 1;
                short damage = 0;
                if (colons.length > 1) {
                    quantity = Integer.parseInt(colons[1]);
                }
                if (colons.length > 2) {
                    damage = (short)Integer.parseInt(colons[2]);
                }
                if (mat != null) {
                    this.recipe.add(new RecipeIngredient(mat, quantity, damage));
                } else if (customItemNames.contains(colons[0])) {
                    this.recipe.add(new RecipeIngredient(colons[0], quantity, damage));
                } else {
                    ProjectKorraItems.log.info("invalid recipe material: " + colons[0]);
                    this.valid = false;
                }
                ++n2;
            }
            while (this.recipe.size() < 9) {
                this.recipe.add(new RecipeIngredient(Material.AIR));
            }
        }
        catch (Exception e) {
            ProjectKorraItems.log.info("an error occured while parsing the recipe: " + s);
            this.valid = false;
        }
    }

    public void build() {
        if (this.alreadyFinal) {
            return;
        }
        this.alreadyFinal = true;
        if (!this.valid) {
            ProjectKorraItems.log.info("an error occured while parsing the item: " + this.toString());
        } else if (items.containsKey(this.name.toLowerCase())) {
            ProjectKorraItems.log.info("an item with this name already exists: " + this.toString());
        } else if (this.name.length() == 0) {
            ProjectKorraItems.log.info("invalid name: " + this.toString());
        } else if (this.displayName.length() == 0) {
            ProjectKorraItems.log.info("invalid display name: " + this.toString());
        } else if (this.material == null) {
            ProjectKorraItems.log.info("invalid material: " + this.toString());
        } else {
            items.put(this.name.toLowerCase(), this);
            itemList.add(this);
        }
    }

    public ItemStack generateItem() {
        ItemStack istack = new ItemStack(this.material, this.quantity, this.damage);
        ItemMeta meta = istack.getItemMeta();
        ArrayList<String> tempLore = new ArrayList<String>(this.lore);
        meta.setDisplayName(this.displayName);
        for (Attribute attr : this.attributes) {
            try {
                if (attr.getName().equalsIgnoreCase("Charges")) {
                    tempLore.add(String.valueOf(AttributeList.CHARGES_STR) + Integer.parseInt(attr.getValues().get(0)));
                } else if (attr.getName().equalsIgnoreCase("ClickCharges")) {
                    tempLore.add(String.valueOf(AttributeList.CLICK_CHARGES_STR) + Integer.parseInt(attr.getValues().get(0)));
                } else if (attr.getName().equalsIgnoreCase("SneakCharges")) {
                    tempLore.add(String.valueOf(AttributeList.SNEAK_CHARGES_STR) + Integer.parseInt(attr.getValues().get(0)));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!attr.getName().equalsIgnoreCase("LeatherColor")) continue;
                LeatherArmorMeta lmeta = (LeatherArmorMeta)meta;
                lmeta.setColor(Color.fromRGB((int)Integer.parseInt(attr.getValues().get(0).trim()), (int)Integer.parseInt(attr.getValues().get(1).trim()), (int)Integer.parseInt(attr.getValues().get(2).trim())));
                meta = lmeta;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        meta.setLore(tempLore);
        istack.setItemMeta(meta);
        if (this.glow) {
            EnchantGlow.addGlow(istack);
        }
        return istack;
    }

    public boolean getBooleanAttributeValue(String attrib) {
        for (Attribute attr : this.attributes) {
            if (!attr.getBooleanValue(attrib)) continue;
            return true;
        }
        return false;
    }

    public static ConcurrentHashMap<String, PKItem> getItems() {
        return items;
    }

    public static void setItems(ConcurrentHashMap<String, PKItem> items) {
        PKItem.items = items;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public ArrayList<String> getLore() {
        return this.lore;
    }

    public void setLore(ArrayList<String> lore) {
        this.lore = lore;
    }

    public Material getMaterial() {
        return this.material;
    }

    public ArrayList<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String attrName) {
        for (Attribute attr : this.attributes) {
            if (!attr.getName().equalsIgnoreCase(attrName)) continue;
            return attr;
        }
        return null;
    }

    public void setAttributes(ArrayList<Attribute> attributes) {
        this.attributes = attributes;
    }

    public void setDamage(short damage) {
        this.damage = damage;
    }

    public void setMaterial(Material material) {
        this.material = material;
    }

    public int getQuantity() {
        return this.quantity;
    }

    public void setQuantity(int quantity) {
        this.quantity = quantity;
    }

    public short getDamage() {
        return this.damage;
    }

    public void setData(short damage) {
        this.damage = damage;
    }

    public ArrayList<RecipeIngredient> getRecipe() {
        return this.recipe;
    }

    public void setRecipe(ArrayList<RecipeIngredient> recipe) {
        this.recipe = recipe;
    }

    public boolean isUnshapedRecipe() {
        return this.unshapedRecipe;
    }

    public void setUnshapedRecipe(boolean unshapedRecipe) {
        this.unshapedRecipe = unshapedRecipe;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public String toString() {
        return "CustomItem [name=" + this.name + ", displayName=" + this.displayName + ", lore=" + this.lore + ", material=" + this.material + ", quantity=" + this.quantity + ", damage=" + this.damage;
    }

    public static String colorizeString(String s) {
        s = s.replaceAll("<", "");
        s = s.replaceAll(">", "");
        s = ChatColor.translateAlternateColorCodes((char)'&', (String)s);
        return s;
    }

    public static PKItem getCustomItem(ItemStack istack) {
        if (istack == null) {
            return null;
        }
        ItemMeta meta = istack.getItemMeta();
        if (meta == null || meta.getDisplayName() == null) {
            return null;
        }
        for (PKItem citem : items.values()) {
            if (!meta.getDisplayName().equals(citem.getDisplayName())) continue;
            return citem;
        }
        return null;
    }

    public static PKItem getCustomItem(String itemName) {
        if (items.containsKey(itemName.toLowerCase())) {
            return items.get(itemName.toLowerCase());
        }
        return null;
    }
}

