/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.customs;

import com.projectkorra.items.Messages;
import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.customs.PKItem;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PKIEquip {
    public static final ConcurrentHashMap<String, PKIEquip> INSTANCES = new ConcurrentHashMap();
    private PKItem customItem;
    private ItemStack item;
    private Player player;

    public PKIEquip(Player player) {
        String name = player.getName();
        if (INSTANCES.containsKey(name)) {
            PKIEquip itemEq = INSTANCES.get(name);
            INSTANCES.remove(name);
            player.sendMessage(String.valueOf(Messages.EQUIP_OFF) + " " + itemEq.customItem.getDisplayName());
            return;
        }
        ItemStack inhand = player.getItemInHand();
        PKItem citem = PKItem.getCustomItem(inhand);
        if (citem == null) {
            player.sendMessage(Messages.CANT_EQUIP);
            return;
        }
        player.sendMessage(String.valueOf(Messages.EQUIP_ON) + " " + citem.getDisplayName());
        this.customItem = citem;
        this.item = inhand;
        this.player = player;
        INSTANCES.put(name, this);
    }

    public static boolean updatePlayerSlot(Player player, int prevSlot, int newSlot) {
        String name = player.getName();
        if (!INSTANCES.containsKey(name)) {
            return false;
        }
        PlayerInventory inv = player.getInventory();
        PKIEquip itemEq = INSTANCES.get(name);
        ItemStack newSlotItem = inv.getItem(newSlot);
        ItemStack prevSlotItem = inv.getItem(prevSlot);
        if (newSlotItem != null && newSlotItem.getType() != Material.AIR) {
            return false;
        }
        if (inv.contains(itemEq.item)) {
            int foundSlot = inv.first(itemEq.item);
            final ItemStack foundItem = inv.getItem(foundSlot);
            PKIEquip fitemEq = itemEq;
            new BukkitRunnable(){

                public void run() {
                    PKIEquip.this.item = foundItem;
                }
            }.runTaskLater((Plugin)ProjectKorraItems.plugin, 1L);
            inv.setItem(newSlot, foundItem);
            inv.setItem(foundSlot, new ItemStack(Material.AIR));
            return true;
        }
        if (prevSlotItem != null && prevSlotItem.hasItemMeta() && prevSlotItem.getItemMeta().hasDisplayName() && prevSlotItem.getItemMeta().getDisplayName().equals(itemEq.customItem.getDisplayName())) {
            final ItemStack prevItem = inv.getItem(prevSlot);
            PKIEquip fitemEq = itemEq;
            new BukkitRunnable(){

                public void run() {
                    PKIEquip.this.item = prevItem;
                }
            }.runTaskLater((Plugin)ProjectKorraItems.plugin, 1L);
            inv.setItem(newSlot, prevItem);
            inv.setItem(prevSlot, new ItemStack(Material.AIR));
            return true;
        }
        return false;
    }

    public PKItem getCustomItem() {
        return this.customItem;
    }

    public void setCustomItem(PKItem customItem) {
        this.customItem = customItem;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public void setItem(ItemStack item) {
        this.item = item;
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }
}

