/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.customs;

import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.customs.PKItem;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class PKIDisplay {
    public static ConcurrentHashMap<Player, PKIDisplay> displays;
    public static final ItemStack PREV_BUTTON;
    public static final ItemStack NEXT_BUTTON;
    public static final int INV_SIZE = 27;
    public static final int INV_ITEM_QTY = 18;
    private Player player;
    private boolean showStats;
    private boolean showingRecipeInv;
    private int page;
    private Inventory inventory;
    private Inventory prevInv;

    static {
        PREV_BUTTON = new ItemStack(Material.WOOL, 1, 14);
        NEXT_BUTTON = new ItemStack(Material.WOOL, 1, 5);
    }

    public PKIDisplay(Player player, boolean showStats, int page) {
        this.player = player;
        this.showStats = showStats;
        this.page = page;
        ItemMeta meta1 = PREV_BUTTON.getItemMeta();
        meta1.setDisplayName(ChatColor.RED + "Prev");
        PREV_BUTTON.setItemMeta(meta1);
        ItemMeta meta2 = NEXT_BUTTON.getItemMeta();
        meta2.setDisplayName(ChatColor.GREEN + "Next");
        NEXT_BUTTON.setItemMeta(meta2);
        this.createInventory();
    }

    public PKIDisplay(Player player, boolean showStats) {
        this(player, showStats, 0);
    }

    public PKIDisplay(Player player) {
        this(player, false, 0);
    }

    public void createInventory() {
        Inventory inv;
        if (this.page < 0) {
            this.page = 0;
        }
        if (displays.containsKey(this.player)) {
            inv = PKIDisplay.displays.get((Object)this.player).inventory;
            if (inv.getViewers().size() > 0) {
                return;
            }
            displays.remove(this.player);
        }
        inv = Bukkit.createInventory(null, (int)27, (String)"Bending Items");
        ArrayList<ItemStack> cistacks = new ArrayList<ItemStack>();
        for (PKItem citem : PKItem.itemList) {
            ArrayList<String> lore;
            ItemStack istack = citem.generateItem();
            ItemMeta meta = istack.getItemMeta();
            if (this.showStats) {
                lore = new ArrayList<String>();
                for (Attribute att : citem.getAttributes()) {
                    if (att.getValues().toString().length() < 40) {
                        lore.add(new String(String.valueOf(att.getName()) + ":" + att.getValues()));
                        continue;
                    }
                    lore.add(new String(att.getName()));
                }
                meta.setLore(lore);
            } else {
                lore = meta.getLore();
                if (lore == null) {
                    lore = new ArrayList();
                }
                String s = "";
                s = citem.getRecipe().size() == 0 ? ChatColor.RED + "Uncraftable" : (citem.isUnshapedRecipe() ? ChatColor.GREEN + "Craftable (unshaped)" : ChatColor.GREEN + "Craftable (shaped)");
                lore.add(s);
                meta.setLore(lore);
            }
            istack.setItemMeta(meta);
            cistacks.add(istack);
        }
        int i = 18 * this.page;
        while (i < 18 * (this.page + 1)) {
            if (i < 0 || i >= cistacks.size()) break;
            inv.addItem(new ItemStack[]{(ItemStack)cistacks.get(i)});
            ++i;
        }
        if (cistacks.size() > 18) {
            inv.setItem(26, NEXT_BUTTON);
        }
        if (this.page > 0) {
            inv.setItem(18, PREV_BUTTON);
        }
        this.inventory = inv;
        displays.put(this.player, this);
        this.player.openInventory(inv);
    }

    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public boolean isShowStats() {
        return this.showStats;
    }

    public void setShowStats(boolean showStats) {
        this.showStats = showStats;
    }

    public int getPage() {
        return this.page;
    }

    public void setPage(int page) {
        this.page = page;
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public void setInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    public boolean isShowingRecipeInv() {
        return this.showingRecipeInv;
    }

    public void setShowingRecipeInv(boolean showingRecipeInv) {
        this.showingRecipeInv = showingRecipeInv;
    }

    public Inventory getPrevInv() {
        return this.prevInv;
    }

    public void setPrevInv(Inventory prevInv) {
        this.prevInv = prevInv;
    }

    public static void cleanup() {
        for (PKIDisplay d : displays.values()) {
            d.getPlayer().closeInventory();
            displays.remove(d);
        }
    }
}

