/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.command;

import com.projectkorra.items.Messages;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.attribute.AttributeList;
import com.projectkorra.items.command.PKICommand;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class StatsCommand
extends PKICommand {
    public StatsCommand() {
        super("stats", "/bending items stats", "This command lists all stats which can be applied to a bending item", Messages.STATS_ALIAS);
    }

    public void execute(CommandSender sender, List<String> args) {
        if (this.correctLength(sender, args.size(), 0, 1) && args.size() >= 0) {
            if (!this.hasPermission(sender)) {
                sender.sendMessage(Messages.NO_PERM);
                return;
            }
            if (args.size() >= 0) {
                int page = 1;
                String phrase = null;
                if (args.size() == 1) {
                    try {
                        page = Integer.parseInt(args.get(0));
                    }
                    catch (Exception e) {
                        phrase = args.get(0);
                    }
                } else if (args.size() == 1) {
                    phrase = args.get(0);
                    try {
                        page = Integer.parseInt(args.get(0));
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                ArrayList<Attribute> attribs = new ArrayList<Attribute>(AttributeList.ATTRIBUTES);
                if (phrase != null) {
                    int i = 0;
                    while (i < attribs.size()) {
                        Attribute att = attribs.get(i);
                        if (!att.getName().toLowerCase().contains(phrase.toLowerCase())) {
                            attribs.remove(i);
                            --i;
                        }
                        ++i;
                    }
                }
                int maxPage = (attribs.size() - 1) / 10;
                page = --page < 0 ? 0 : page;
                page = page > maxPage ? maxPage : page;
                int pageIndex = page * 10;
                sender.sendMessage(ChatColor.YELLOW + " ---- " + ChatColor.GOLD + "Stats " + ChatColor.YELLOW + "-- " + ChatColor.GOLD + "Page " + ChatColor.RED + (page + 1) + ChatColor.GOLD + "/" + ChatColor.RED + (maxPage + 1) + ChatColor.YELLOW + " ----");
                int i = pageIndex;
                while (i < pageIndex + 10) {
                    if (i < 0 || i >= attribs.size()) break;
                    Attribute att = attribs.get(i);
                    sender.sendMessage(ChatColor.YELLOW + att.getName() + ": " + ChatColor.WHITE + att.getDesc());
                    ++i;
                }
                if (phrase != null) {
                    sender.sendMessage(ChatColor.GOLD + "Phrase: " + ChatColor.RED + phrase);
                }
                return;
            }
        }
    }
}

