/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.attribute;

import com.projectkorra.items.attribute.Action;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.items.Glider;
import com.projectkorra.items.utils.AttributeUtils;
import com.projectkorra.items.utils.ItemUtils;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerAnimationEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.ItemStack;

public class AttributeListener
implements Listener {
    public static final ConcurrentHashMap<String, ConcurrentHashMap<String, Attribute>> currentBendingEffects = new ConcurrentHashMap();

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        new Glider(player);
        if (!player.isSneaking()) {
            ItemUtils.updateOnActionEffects(player, Action.SHIFT);
            ItemUtils.handleItemSource(player, "WaterSource", new ItemStack(Material.POTION));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerSwing(PlayerAnimationEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ItemUtils.updateOnActionEffects(player, Action.LEFT_CLICK);
        ItemUtils.handleItemSource(player, "WaterSource", new ItemStack(Material.POTION));
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemUtils.updateOnActionEffects(event.getPlayer(), Action.CONSUME);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChangeItem(PlayerItemHeldEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ConcurrentHashMap<String, Double> attribs = AttributeUtils.getSimplePlayerAttributeMap(player);
        boolean auto = Attribute.getBooleanValue("AirGlideAutomatic", attribs);
        if (auto) {
            new Glider(player, true);
        }
    }
}

