/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.attribute;

import com.projectkorra.items.attribute.AttributeList;
import com.projectkorra.projectkorra.Element;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;

public class Attribute {
    private String name;
    private String desc;
    private ArrayList<String> values;
    private Element element;
    private double duration;
    private double time;
    private int benefit;

    public Attribute(String name, String desc, Element element, int benefit) {
        this.name = name;
        this.desc = desc;
        this.element = element;
        this.benefit = benefit;
        this.duration = 0.0;
        this.time = 0.0;
        this.values = new ArrayList();
    }

    public Attribute(Attribute other) {
        this.name = other.name;
        this.desc = other.desc;
        this.time = other.time;
        this.duration = other.duration;
        this.element = other.element;
        this.benefit = other.benefit;
        this.values = new ArrayList();
        for (String str : other.values) {
            this.values.add(new String(str));
        }
    }

    public Attribute(String name, String desc, Element element) {
        this(name, desc, element, 1);
    }

    public Attribute(String name, String desc) {
        this(name, desc, null);
    }

    public Attribute(String name) {
        this(name, "");
    }

    public Attribute() {
        this("");
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public double getTime() {
        return this.time;
    }

    public Element getElement() {
        return this.element;
    }

    public void setElement(Element element) {
        this.element = element;
    }

    public int getBenefit() {
        return this.benefit;
    }

    public void setBenefit(int benefit) {
        this.benefit = benefit;
    }

    public void setTime(double time) {
        this.time = time;
    }

    public double getDuration() {
        return this.duration;
    }

    public void setDuration(double duration) {
        this.duration = duration;
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public ArrayList<String> getValues() {
        return this.values;
    }

    public double getValueAsDouble() {
        if (this.values.size() == 0) {
            return 0.0;
        }
        try {
            return Double.parseDouble(this.values.get(0));
        }
        catch (NumberFormatException e) {
            return 0.0;
        }
    }

    public void setValues(ArrayList<String> values) {
        this.values = values;
    }

    public void setValues(double val) {
        this.values = new ArrayList();
        this.values.add(String.valueOf(val));
    }

    public static Attribute getAttribute(String name) {
        if (name == null) {
            return null;
        }
        for (Attribute att : AttributeList.ATTRIBUTES) {
            if (!att.getName().equalsIgnoreCase(name)) continue;
            return att;
        }
        return null;
    }

    public String toString() {
        return "Attribute [name=" + this.name + ", desc=" + this.desc + ", values=" + this.values + ", time=" + this.time + "]";
    }

    public boolean getBooleanValue(String name) {
        if (!this.name.equalsIgnoreCase(name)) {
            return false;
        }
        try {
            boolean val = Integer.parseInt(this.values.get(0)) != 0;
            return val;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean getBooleanValue(String name, ConcurrentHashMap<String, Double> map) {
        boolean val = map.containsKey(name);
        if (val) {
            try {
                val = map.get(name).intValue() != 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return val;
    }
}

