/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items.abilityupdater;

import com.projectkorra.items.Messages;
import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.abilityupdater.AirUpdater;
import com.projectkorra.items.abilityupdater.ChiUpdater;
import com.projectkorra.items.abilityupdater.EarthUpdater;
import com.projectkorra.items.abilityupdater.FireUpdater;
import com.projectkorra.items.abilityupdater.WaterUpdater;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.customs.PKItem;
import com.projectkorra.items.utils.AttributeUtils;
import com.projectkorra.items.utils.ItemUtils;
import com.projectkorra.projectkorra.event.AbilityDamageEntityEvent;
import com.projectkorra.projectkorra.event.AbilityStartEvent;
import com.projectkorra.projectkorra.util.ParticleEffect;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class AbilityUpdater
implements Listener {
    @EventHandler
    public void onDamage(AbilityDamageEntityEvent event) {
        AbilityUpdater.updateAbilityDamage(event.getAbility().getPlayer(), event.getAbility());
    }

    @EventHandler
    public void onStart(AbilityStartEvent event) {
        AbilityUpdater.updateAbility(event.getAbility().getPlayer(), event.getAbility());
    }

    public static void updateAbility(Player player, Object ability) {
        if (player == null) {
            return;
        }
        boolean abilityAdded = true;
        ConcurrentHashMap<String, Double> attribs = AttributeUtils.getSimplePlayerAttributeMap(player);
        if (FireUpdater.updateAbility(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (WaterUpdater.updateAbility(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (AirUpdater.updateAbility(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (EarthUpdater.updateAbility(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (ChiUpdater.updateAbility(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else {
            abilityAdded = false;
        }
        if (abilityAdded) {
            AbilityUpdater.updatePlayerParticles(player);
        }
    }

    public static void updateAbilityDamage(Player player, Object ability) {
        if (player == null) {
            return;
        }
        boolean abilityAdded = true;
        ConcurrentHashMap<String, Double> attribs = AttributeUtils.getSimplePlayerAttributeMap(player);
        if (FireUpdater.updateAbilityDamage(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (WaterUpdater.updateAbilityDamage(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (AirUpdater.updateAbilityDamage(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (EarthUpdater.updateAbilityDamage(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else if (ChiUpdater.updateAbilityDamage(player, ability, attribs)) {
            AttributeUtils.decreaseCharges(player, null);
        } else {
            abilityAdded = false;
        }
        if (abilityAdded) {
            AbilityUpdater.updatePlayerParticles(player);
        }
    }

    private static void updatePlayerParticles(Player player) {
        ArrayList<ItemStack> equipment = ItemUtils.getPlayerValidEquipment(player);
        for (ItemStack istack : equipment) {
            Attribute attr;
            PKItem citem = PKItem.getCustomItem(istack);
            if (citem == null || (attr = citem.getAttribute("ParticleEffects")) == null) continue;
            ArrayList<String> values = attr.getValues();
            for (String value : values) {
                String[] colonSplit = value.split(":");
                if (colonSplit.length == 0) continue;
                String particleName = colonSplit[0];
                ParticleEffect effect = ParticleEffect.fromName((String)particleName.trim());
                if (effect == null) {
                    Messages.logTimedMessage("this particle effect could not be found: " + particleName);
                    continue;
                }
                double amount = 1.0;
                double radius = 100.0;
                double duration = 1.0;
                double speed = 0.0;
                try {
                    if (colonSplit.length >= 2) {
                        amount = Double.parseDouble(colonSplit[1]);
                    }
                    if (colonSplit.length >= 3) {
                        radius = Double.parseDouble(colonSplit[2]);
                    }
                    if (colonSplit.length >= 4) {
                        duration = Double.parseDouble(colonSplit[3]);
                    }
                    if (colonSplit.length >= 5) {
                        speed = Double.parseDouble(colonSplit[4]);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                final ParticleEffect feffect = effect;
                final double fradius = radius /= 100.0;
                final double famount = amount;
                final double fspeed = speed /= 100.0;
                final Player fplayer = player;
                int i = 0;
                while ((double)i < duration) {
                    new BukkitRunnable(){

                        public void run() {
                            feffect.display(fplayer.getEyeLocation(), (float)fradius, (float)fradius, (float)fradius, (float)fspeed, (int)famount);
                        }
                    }.runTaskLater((Plugin)ProjectKorraItems.plugin, (long)i);
                    ++i;
                }
            }
        }
    }
}

