/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items;

import com.projectkorra.items.Messages;
import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.attribute.Action;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.customs.PKIDisplay;
import com.projectkorra.items.customs.PKIEquip;
import com.projectkorra.items.customs.PKItem;
import com.projectkorra.items.customs.RecipeIngredient;
import com.projectkorra.items.items.Glider;
import com.projectkorra.items.utils.AttributeUtils;
import com.projectkorra.items.utils.ItemUtils;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerItemHeldEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class PKIListener
implements Listener {
    @EventHandler(priority=EventPriority.NORMAL)
    public void onCraftingPlace(InventoryClickEvent event) {
        if (event.isCancelled() || event.getInventory().getType() != InventoryType.WORKBENCH) {
            return;
        }
        final HumanEntity humEnt = event.getWhoClicked();
        final InventoryClickEvent fevent = event;
        if (!(humEnt instanceof Player)) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                Player player = (Player)humEnt;
                ItemStack[] tempInvItems = fevent.getInventory().getContents();
                ArrayList<ItemStack> originalInvItems = new ArrayList<ItemStack>();
                ItemStack[] itemStackArray = tempInvItems;
                int n = tempInvItems.length;
                int n2 = 0;
                while (n2 < n) {
                    ItemStack istack = itemStackArray[n2];
                    originalInvItems.add(istack);
                    ++n2;
                }
                originalInvItems.remove(0);
                ArrayList invItemsClone = (ArrayList)originalInvItems.clone();
                for (PKItem citem : PKItem.items.values()) {
                    if (citem.getRecipe().size() == 0) continue;
                    ArrayList recipeClone = (ArrayList)citem.getRecipe().clone();
                    boolean validShape = true;
                    int maxQuantity = Integer.MAX_VALUE;
                    invItemsClone = (ArrayList)originalInvItems.clone();
                    int i = 0;
                    while (i < recipeClone.size()) {
                        RecipeIngredient ing = (RecipeIngredient)recipeClone.get(i);
                        int j = 0;
                        while (j < invItemsClone.size()) {
                            if (i > 0 || j > 0) {
                                validShape = false;
                            }
                            ItemStack item = (ItemStack)invItemsClone.get(j);
                            PKItem citemInSlot = PKItem.getCustomItem(item);
                            if (ing.getMaterial() == Material.AIR && item.getType() == Material.AIR) {
                                recipeClone.remove(i);
                                invItemsClone.remove(j);
                                --i;
                                --j;
                                break;
                            }
                            if (item.getAmount() >= ing.getQuantity() && (!ing.isCustomItem() && ing.getMaterial() == item.getType() && item.getDurability() == ing.getDamage() || citemInSlot != null && citemInSlot.getName().equals(ing.getCustomItemName()))) {
                                if (item.getAmount() / ing.getQuantity() < maxQuantity) {
                                    maxQuantity = item.getAmount() / ing.getQuantity();
                                }
                                recipeClone.remove(i);
                                invItemsClone.remove(j);
                                --i;
                                --j;
                                break;
                            }
                            ++j;
                        }
                        ++i;
                    }
                    if (recipeClone.size() != 0 || invItemsClone.size() != 0 || !citem.isUnshapedRecipe() && !validShape) continue;
                    ItemStack newItem = citem.generateItem();
                    newItem.setAmount(maxQuantity * newItem.getAmount());
                    fevent.getInventory().setItem(0, newItem);
                    player.updateInventory();
                    return;
                }
            }
        }.runTaskLater((Plugin)ProjectKorraItems.plugin, 1L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onGrabResultItem(InventoryClickEvent event) {
        if (event.isCancelled() || event.getSlotType() != InventoryType.SlotType.RESULT || event.getSlot() != 0 || event.getInventory().getType() != InventoryType.WORKBENCH) {
            return;
        }
        HumanEntity humEnt = event.getWhoClicked();
        if (!(humEnt instanceof Player)) {
            return;
        }
        Player player = (Player)humEnt;
        ItemStack curItem = event.getCurrentItem();
        if (curItem == null) {
            return;
        }
        PKItem citem = PKItem.getCustomItem(curItem);
        if (citem == null) {
            return;
        }
        int amountCreated = curItem.getAmount() / citem.getQuantity();
        ItemStack[] tempInvItems = event.getInventory().getContents();
        ArrayList recipeClone = (ArrayList)citem.getRecipe().clone();
        ArrayList<ItemStack> invItems = new ArrayList<ItemStack>();
        ItemStack[] itemStackArray = tempInvItems;
        int n = tempInvItems.length;
        int n2 = 0;
        while (n2 < n) {
            ItemStack istack = itemStackArray[n2];
            invItems.add(istack);
            ++n2;
        }
        invItems.set(0, new ItemStack(Material.AIR));
        while (recipeClone.size() > 0) {
            RecipeIngredient ing = (RecipeIngredient)recipeClone.get(0);
            int ingQuantity = ing.getQuantity() * amountCreated;
            if (ing.getMaterial() != Material.AIR) {
                int i = 0;
                while (i < invItems.size()) {
                    ItemStack istack = (ItemStack)invItems.get(i);
                    PKItem istackCustomItem = PKItem.getCustomItem(istack);
                    if (!(!ing.isCustomItem() && istack.getDurability() != ing.getDamage() || !ing.isCustomItem() && istack.getType() != ing.getMaterial() || ing.isCustomItem() && istackCustomItem == null || ing.isCustomItem() && !istackCustomItem.getName().equals(ing.getCustomItemName()))) {
                        int itemQuantity = istack.getAmount();
                        if (ingQuantity > itemQuantity) {
                            invItems.set(i, new ItemStack(Material.AIR));
                            ingQuantity -= itemQuantity;
                        } else {
                            if (ingQuantity == itemQuantity) {
                                invItems.set(i, new ItemStack(Material.AIR));
                                break;
                            }
                            if (ingQuantity < itemQuantity) {
                                istack.setAmount(itemQuantity - ingQuantity);
                                break;
                            }
                        }
                    }
                    ++i;
                }
            }
            recipeClone.remove(0);
        }
        event.getInventory().clear();
        player.setItemOnCursor(curItem);
        final ItemStack[] finalItems = invItems.toArray(new ItemStack[invItems.size()]);
        final InventoryClickEvent fevent = event;
        final Player fplayer = player;
        new BukkitRunnable(){

            public void run() {
                fevent.getInventory().setContents(finalItems);
                fplayer.updateInventory();
            }
        }.runTaskLater((Plugin)ProjectKorraItems.plugin, 1L);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onClickInDisplayInv(InventoryClickEvent event) {
        PKIDisplay disp2;
        if (event.isCancelled()) {
            return;
        }
        HumanEntity humEnt = event.getWhoClicked();
        if (!(humEnt instanceof Player)) {
            return;
        }
        Inventory inv = event.getInventory();
        Player player = (Player)humEnt;
        for (PKIDisplay disp2 : PKIDisplay.displays.values()) {
            if (!disp2.getInventory().equals(inv)) continue;
            event.setCancelled(true);
        }
        if (!PKIDisplay.displays.containsKey(player)) {
            return;
        }
        disp2 = PKIDisplay.displays.get(player);
        boolean hasPerm = player.hasPermission("bendingitems.command.give");
        if (hasPerm && event.getClick() == ClickType.RIGHT && player.getItemOnCursor().getType() != Material.AIR && !disp2.isShowStats()) {
            event.setCancelled(false);
            return;
        }
        ItemStack curItem = event.getCurrentItem();
        if (curItem == null) {
            return;
        }
        if (curItem.equals((Object)PKIDisplay.NEXT_BUTTON)) {
            player.closeInventory();
            disp2.setPage(disp2.getPage() + 1);
            disp2.createInventory();
            return;
        }
        if (curItem.equals((Object)PKIDisplay.PREV_BUTTON)) {
            player.closeInventory();
            if (!disp2.isShowingRecipeInv()) {
                disp2.setPage(disp2.getPage() - 1);
                disp2.createInventory();
            } else {
                disp2.createInventory();
            }
            return;
        }
        PKItem citem = PKItem.getCustomItem(curItem);
        if (citem == null) {
            return;
        }
        if (hasPerm && event.getClick() == ClickType.RIGHT && !disp2.isShowStats()) {
            player.setItemOnCursor(citem.generateItem());
            return;
        }
        String displayName = citem.getDisplayName();
        if (displayName.length() > 32) {
            displayName = displayName.substring(0, 32);
        }
        Inventory recInv = Bukkit.createInventory(null, (int)27, (String)displayName);
        int i = 0;
        while (i < citem.getRecipe().size()) {
            RecipeIngredient ing = citem.getRecipe().get(i);
            int pos = i % 3 + 3 + i / 3 * 9;
            recInv.setItem(pos, ing.getItemStack());
            ++i;
        }
        recInv.setItem(18, PKIDisplay.PREV_BUTTON);
        PKIDisplay.displays.put(player, disp2);
        disp2.setInventory(recInv);
        disp2.setShowingRecipeInv(true);
        player.openInventory(recInv);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onCloseDisplayInv(InventoryCloseEvent event) {
        HumanEntity humEnt = event.getPlayer();
        if (!(humEnt instanceof Player)) {
            return;
        }
        Inventory inv = event.getInventory();
        Player player = (Player)humEnt;
        for (PKIDisplay disp : PKIDisplay.displays.values()) {
            if (!disp.getInventory().equals(inv)) continue;
            PKIDisplay.displays.remove(player);
            return;
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onAnvilItemPlace(InventoryClickEvent event) {
        if (event.isCancelled() || event.getInventory().getType() != InventoryType.ANVIL) {
            return;
        }
        HumanEntity humEnt = event.getWhoClicked();
        if (!(humEnt instanceof Player)) {
            return;
        }
        Player player = (Player)humEnt;
        ItemStack cursorItem = event.getCurrentItem();
        if (cursorItem == null) {
            return;
        }
        PKItem citem = PKItem.getCustomItem(cursorItem);
        if (citem == null) {
            return;
        }
        event.setCancelled(true);
        player.sendMessage(Messages.NO_ANVIL);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerItemChange(PlayerItemHeldEvent event) {
        PKIEquip.updatePlayerSlot(event.getPlayer(), event.getPreviousSlot(), event.getNewSlot());
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerSneak(PlayerToggleSneakEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        new Glider(player);
        if (!player.isSneaking()) {
            ItemUtils.updateOnActionEffects(player, Action.SHIFT);
            ItemUtils.handleItemSource(player, "WaterSource", new ItemStack(Material.POTION));
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        org.bukkit.event.block.Action a = event.getAction();
        if (a == org.bukkit.event.block.Action.LEFT_CLICK_AIR || a == org.bukkit.event.block.Action.LEFT_CLICK_BLOCK) {
            ItemUtils.updateOnActionEffects(player, Action.LEFT_CLICK);
            ItemUtils.handleItemSource(player, "WaterSource", new ItemStack(Material.POTION));
        } else if (a != org.bukkit.event.block.Action.RIGHT_CLICK_AIR) {
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerConsume(PlayerItemConsumeEvent event) {
        if (event.isCancelled()) {
            return;
        }
        ItemUtils.updateOnActionEffects(event.getPlayer(), Action.CONSUME);
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onChangeItem(PlayerItemHeldEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Player player = event.getPlayer();
        ConcurrentHashMap<String, Double> attribs = AttributeUtils.getSimplePlayerAttributeMap(player);
        boolean auto = Attribute.getBooleanValue("AirGlideAutomatic", attribs);
        if (auto) {
            new Glider(player, true);
        }
    }
}

