/*
 * Decompiled with CFR 0.152.
 */
package com.projectkorra.items;

import com.projectkorra.items.ProjectKorraItems;
import com.projectkorra.items.attribute.Attribute;
import com.projectkorra.items.customs.PKItem;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ConfigManager {
    public static final String PATH = ProjectKorraItems.plugin.getDataFolder() + "/config.yml";
    public static final String ITEM_PREF = "Item:";
    public static final String DNAME_PREF = "DisplayName:";
    public static final String NAME_PREF = "Name:";
    public static final String LORE_PREF = "Lore:";
    public static final String SHAPED_RECIPE_PREF = "ShapedRecipe:";
    public static final String UNSHAPED_RECIPE_PREF = "UnshapedRecipe:";
    public static final String MATERIAL_PREF = "Material:";
    public static final String DURA_PREF = "Durability:";
    public static final String AMT_PREF = "Amount:";
    public static final String ATTR_PREF = "Stats:";
    public static final String GLOW_PREF = "Glow:";
    public static final String[] PREFIXES = new String[]{"Item:", "DisplayName:", "Name:", "Lore:", "ShapedRecipe:", "UnshapedRecipe:", "Material:", "Durability:", "Amount:", "Stats:", "Glow:"};

    public ConfigManager() {
        PKItem.items.clear();
        PKItem.itemList.clear();
        ProjectKorraItems.plugin.saveDefaultConfig();
        String str = this.readConfig();
        Set<String> customItemNames = this.getConfigItemNames(str);
        this.analyzeConfig(str, customItemNames);
    }

    public String readConfig() {
        String configStr = "";
        BufferedReader br = null;
        try {
            br = new BufferedReader(new FileReader(PATH));
        }
        catch (FileNotFoundException e) {
            ProjectKorraItems.log.info("config.yml was not found");
            return configStr;
        }
        try {
            try {
                StringBuilder sb = new StringBuilder();
                String line = br.readLine();
                while (line != null) {
                    sb.append(line);
                    sb.append("\n");
                    line = br.readLine();
                }
                configStr = sb.toString();
            }
            catch (IOException e) {
                ProjectKorraItems.log.info("a problem occured while reading config.yml");
                String string = configStr;
                try {
                    br.close();
                }
                catch (IOException e2) {
                    ProjectKorraItems.log.info("a problem occured while reading config.yml");
                    return configStr;
                }
                return string;
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                ProjectKorraItems.log.info("a problem occured while reading config.yml");
                return configStr;
            }
        }
        return configStr;
    }

    public void analyzeConfig(String configStr, Set<String> customItemNames) {
        String[] configLines = configStr.split("\n");
        PKItem newItem = null;
        boolean invalid = false;
        String[] stringArray = configLines;
        int n = configLines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).length() != 0) {
                if (line.toLowerCase().startsWith(ITEM_PREF.toLowerCase())) {
                    if (newItem != null && !invalid) {
                        newItem.build();
                    }
                    invalid = false;
                    newItem = new PKItem();
                } else {
                    String prefix;
                    boolean prefFound = false;
                    String[] stringArray2 = PREFIXES;
                    int n3 = PREFIXES.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        prefix = stringArray2[n4];
                        if (line.toLowerCase().startsWith(prefix.toLowerCase())) {
                            prefFound = true;
                            String tmp = "";
                            try {
                                tmp = line.substring(prefix.length(), line.length());
                                tmp = tmp.trim();
                                if (prefix.equalsIgnoreCase(NAME_PREF)) {
                                    newItem.updateName(tmp);
                                } else if (prefix.equalsIgnoreCase(DNAME_PREF)) {
                                    newItem.updateDisplayName(tmp);
                                } else if (prefix.equalsIgnoreCase(LORE_PREF)) {
                                    newItem.updateLore(tmp);
                                } else if (prefix.equalsIgnoreCase(SHAPED_RECIPE_PREF)) {
                                    newItem.updateRecipe(tmp, customItemNames);
                                    newItem.setUnshapedRecipe(false);
                                } else if (prefix.equalsIgnoreCase(UNSHAPED_RECIPE_PREF)) {
                                    newItem.updateRecipe(tmp, customItemNames);
                                    newItem.setUnshapedRecipe(true);
                                } else if (prefix.equalsIgnoreCase(MATERIAL_PREF)) {
                                    newItem.updateMaterial(tmp);
                                } else if (prefix.equalsIgnoreCase(DURA_PREF)) {
                                    newItem.updateDamage(tmp);
                                } else if (prefix.equalsIgnoreCase(AMT_PREF)) {
                                    newItem.updateQuantity(tmp);
                                } else if (prefix.equalsIgnoreCase(GLOW_PREF)) {
                                    newItem.updateGlow(tmp);
                                }
                            }
                            catch (Exception e) {
                                ProjectKorraItems.log.info("an error occured while parsing the prefix: " + prefix);
                                invalid = false;
                            }
                        }
                        ++n4;
                    }
                    if (!prefFound) {
                        try {
                            prefix = line.substring(0, line.indexOf(":"));
                            String valueStr = line.substring(line.indexOf(":") + 1, line.length()).trim();
                            valueStr = valueStr.replaceAll("(?i)true", "1");
                            valueStr = valueStr.replaceAll("(?i)false", "0");
                            String[] commaSplit = valueStr.split(",");
                            if (commaSplit.length == 0) {
                                ProjectKorraItems.log.info("an attribute is missing it's values: " + line);
                                invalid = false;
                            }
                            Attribute att = Attribute.getAttribute(prefix);
                            Attribute newAtt = new Attribute(att.getName());
                            newAtt.getValues().addAll(Arrays.asList(commaSplit));
                            newItem.getAttributes().add(newAtt);
                        }
                        catch (Exception e) {
                            ProjectKorraItems.log.info("an error occured while parsing the prefix: " + line);
                            invalid = false;
                        }
                    }
                }
            }
            ++n2;
        }
        if (newItem != null && !invalid) {
            newItem.build();
        }
    }

    public Set<String> getConfigItemNames(String config) {
        HashSet<String> names = new HashSet<String>();
        String[] lines = config.split("\n");
        String prefix = NAME_PREF;
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if ((line = line.trim()).toLowerCase().startsWith(prefix.toLowerCase())) {
                String itemName = line.substring(prefix.length(), line.length()).trim();
                names.add(itemName);
            }
            ++n2;
        }
        return names;
    }
}

