/*
 * Decompiled with CFR 0.152.
 */
package me.nestorhd.superkill.utils;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import me.nestorhd.superkill.SuperKillEffect;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class PlayerData {
    private File file;
    private FileConfiguration config;
    private Player p;

    public PlayerData(Player p) {
        this.p = p;
        this.file = new File("plugins/KitPvP/player_data/" + this.p.getUniqueId().toString() + ".yml");
        PlayerData.copyDefaults(this.file);
        new YamlConfiguration();
        this.config = YamlConfiguration.loadConfiguration((File)this.file);
    }

    public void createDataPlayer() {
        try {
            if (!this.file.exists()) {
                this.file.createNewFile();
            }
            this.config.set("name", (Object)this.p.getName());
            this.config.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FileConfiguration get() {
        return this.config;
    }

    public void save() {
        try {
            this.config.save(this.file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void copyDefaults(File playerFile) {
        YamlConfiguration playerConfig = YamlConfiguration.loadConfiguration((File)playerFile);
        InputStreamReader defConfigStream = new InputStreamReader(SuperKillEffect.pl.getResource("player_file.yml"));
        if (defConfigStream != null) {
            YamlConfiguration defConfig = YamlConfiguration.loadConfiguration((Reader)defConfigStream);
            playerConfig.options().copyDefaults(true);
            playerConfig.setDefaults((Configuration)defConfig);
            try {
                playerConfig.save(playerFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

