/*
 * Decompiled with CFR 0.152.
 */
package me.jacobculley.actionapi.action;

import com.google.common.io.ByteArrayDataOutput;
import com.google.common.io.ByteStreams;
import java.util.HashMap;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import me.jacobculley.actionapi.ActionAPI;
import me.jacobculley.actionapi.util.Messages;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class Action {
    private ActionAPI plugin = ActionAPI.getInstance();

    public void executeActions(Player p, List<String> actions) {
        if (actions == null || actions.isEmpty()) {
            return;
        }
        for (String action : actions) {
            this.executeAction(p, action);
        }
    }

    public boolean executeAction(final Player p, String action) {
        double chanceCheck;
        int i;
        int delayTimer = 0;
        int chance = 100;
        if (action.contains("[Chance=")) {
            i = 1;
            while (i <= 100) {
                if (action.contains("[Chance=" + i + "]")) {
                    chance = i;
                    action = action.replace("[Chance=" + i + "] ", "").replace("[Chance=" + i + "]", "");
                }
                ++i;
            }
        }
        if (action.contains("[Delay=")) {
            i = 1;
            while (i < 61) {
                if (action.contains("[Delay=" + i + "]")) {
                    delayTimer = i * 20;
                    action = action.replace("[Delay=" + i + "] ", "").replace("[Delay=" + i + "]", "");
                }
                ++i;
            }
        }
        if (action.contains("[Delay=1000]")) {
            action = action.replace("[Delay=1000]", "");
            delayTimer = 2;
        }
        final String runAction = action;
        if (chance != 100 && (chanceCheck = Math.random() * 100.0) > (double)chance) {
            return false;
        }
        if (delayTimer != 0) {
            Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Action.this.runAction(p, runAction);
                }
            }, (long)delayTimer);
        } else {
            this.runAction(p, runAction);
        }
        return false;
    }

    private void runAction(final Player p, String action) {
        if (action.contains("[SyncTask]")) {
            action = action.replace("[SyncTask] ", "");
            final String runAction = action = action.replace("[SyncTask]", "");
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, new Runnable(){

                @Override
                public void run() {
                    Action.this.runAction(p, runAction);
                }
            });
        }
        action = action.replace("[Delay=0]", "").replace("[Delay=0]", "");
        Messages Messages2 = new Messages();
        if (action.contains("[JavaScript=")) {
            HashMap<String, String> scripts = new HashMap<String, String>();
            String script = null;
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("js");
            engine.put("BukkitPlayer", p);
            engine.put("ActionAPI", (Object)this.plugin);
            engine.put("PlayerCommand", "[PlayerCommand]");
            engine.put("ConsoleCommand", "[ConsoleCommand]");
            engine.put("OperatorCommand", "[OperatorCommand]");
            engine.put("Message", "[Message]");
            engine.put("Broadcast", "[Broadcast]");
            engine.put("Sound", "[Sound]");
            engine.put("VaultGive", "[VaultGive]");
            engine.put("VaultTake", "[VaultTake]");
            engine.put("Teleport", "[Teleport]");
            engine.put("GiveItem", "[GiveItem]");
            engine.put("Title", "[Title]");
            engine.put("ActionBar", "[ActionBar]");
            engine.put("JSONMessage", "[JSONMessage]");
            engine.put("JSONBroadcast", "[JSONBroadcast]");
            engine.put("Bungee", "[Bungee]");
            int i = 0;
            while (i < action.length()) {
                if (action.charAt(i) == '[' && action.substring(i, i + 12).equals("[JavaScript=")) {
                    int e = i + 12;
                    while (e < action.length()) {
                        if (action.charAt(e) == ']') {
                            String orginalScript;
                            script = orginalScript = action.substring(i + 12, e);
                            script = Messages2.setPlaceholders(p, script);
                            String result = null;
                            try {
                                Object obj = engine.eval(script);
                                if (obj != null) {
                                    result = obj.toString();
                                }
                            }
                            catch (ScriptException e2) {
                                e2.printStackTrace();
                            }
                            if (result != null && !result.isEmpty()) {
                                scripts.put(orginalScript, result);
                            }
                            e = action.length();
                        }
                        ++e;
                    }
                }
                ++i;
            }
            if (scripts != null && !scripts.isEmpty()) {
                for (String sc : scripts.keySet()) {
                    action = action.replace("[JavaScript=" + sc + "]", (CharSequence)scripts.get(sc));
                }
            }
        }
        if (action.contains("[PlayerCommand]")) {
            action = Messages2.setPlaceholders(p, action.replace("[PlayerCommand] ", "").replace("[PlayerCommand]", ""));
            p.performCommand(action);
        } else if (action.contains("[ConsoleCommand]")) {
            action = Messages2.setPlaceholders(p, action.replace("[ConsoleCommand] ", "").replace("[ConsoleCommand]", ""));
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getServer().getConsoleSender(), action);
        } else if (action.contains("[OperatorCommand]")) {
            action = Messages2.setPlaceholders(p, action.replace("[OperatorCommand] ", "").replace("[OperatorCommand]", ""));
            if (!p.isOp()) {
                p.setOp(true);
                this.plugin.getServer().dispatchCommand((CommandSender)p, action);
                p.setOp(false);
            } else {
                this.plugin.getServer().dispatchCommand((CommandSender)p, action);
            }
        } else if (action.contains("[Message]")) {
            action = ChatColor.translateAlternateColorCodes((char)'&', (String)Messages2.setPlaceholders(p, action.replace("[Message] ", "").replace("[Message]", "")));
            p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)action));
        } else if (action.contains("[Broadcast]")) {
            action = ChatColor.translateAlternateColorCodes((char)'&', (String)Messages2.setPlaceholders(p, action.replace("[Broadcast] ", "").replace("[Broadcast]", "")));
            this.plugin.getServer().broadcastMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)action));
        } else if (action.contains("[Sound]")) {
            action = Messages2.setPlaceholders(p, action.replace("[Sound] ", "").replace("[Sound]", ""));
            float soundFloat = 1.0f;
            p.playSound(p.getLocation(), Sound.valueOf((String)action.toUpperCase()), 1.0f, 1.0f);
        } else if (action.contains("[VaultGive]")) {
            action = Messages2.setPlaceholders(p, action.replace("[VaultGive] ", "").replace("[VaultGive]", ""));
            int amount = Integer.parseInt(action);
            this.plugin.getHooks().getEcon().depositPlayer((OfflinePlayer)p, (double)amount);
        } else if (action.contains("[VaultTake]")) {
            action = Messages2.setPlaceholders(p, action.replace("[VaultGive] ", "").replace("[VaultGive]", ""));
            int amount = Integer.parseInt(action);
            this.plugin.getHooks().getEcon().withdrawPlayer((OfflinePlayer)p, (double)amount);
        } else if (action.contains("[Teleport]")) {
            World world;
            action = Messages2.setPlaceholders(p, action.replace("[Teleport] ", "").replace("[Teleport]", ""));
            String[] location = action.split(";");
            Location destination = null;
            if (location.length == 4) {
                world = Bukkit.getWorld((String)location[0]);
                double x = Double.parseDouble(location[1]);
                double y = Double.parseDouble(location[2]);
                double z = Double.parseDouble(location[3]);
                destination = new Location(world, x, y, z);
            } else if (location.length == 6) {
                world = Bukkit.getWorld((String)location[0]);
                double x = Double.parseDouble(location[1]);
                double y = Double.parseDouble(location[2]);
                double z = Double.parseDouble(location[3]);
                float yaw = Float.parseFloat(location[4]);
                float pitch = Float.parseFloat(location[5]);
                destination = new Location(world, x, y, z, yaw, pitch);
            }
            if (location != null) {
                p.teleport(destination);
            }
        } else if (action.contains("[GiveItem]")) {
            action = Messages2.setPlaceholders(p, action.replace("[GiveItem] ", "").replace("[GiveItem]", ""));
            String[] item = action.split(";");
            ItemStack newItem = null;
            if (item.length == 1) {
                newItem = new ItemStack(Material.valueOf((String)item[0]), 1);
            } else if (item.length == 2) {
                newItem = new ItemStack(Material.valueOf((String)item[0]), Integer.parseInt(item[1]));
            } else if (item.length == 3) {
                newItem = new ItemStack(Material.valueOf((String)item[0]), Integer.parseInt(item[1]), (short)((byte)Integer.parseInt(item[2])));
            } else if (item.length == 4) {
                newItem = new ItemStack(Material.valueOf((String)item[0]), Integer.parseInt(item[1]), (short)((byte)Integer.parseInt(item[2])));
                ItemMeta meta = newItem.getItemMeta();
                meta.setDisplayName(Messages2.setPlaceholders(p, item[3]));
                newItem.setItemMeta(meta);
            }
            if (newItem != null) {
                if (p.getInventory().firstEmpty() < 0) {
                    p.getWorld().dropItemNaturally(p.getLocation(), newItem);
                } else {
                    p.getInventory().addItem(new ItemStack[]{newItem});
                }
            }
        } else if (action.contains("[Title]")) {
            String[] titleString = (action = Messages2.setPlaceholders(p, action.replace("[Title] ", "").replace("[Title]", ""))).split(";");
            if (titleString.length == 1 || titleString.length == 2) {
                this.plugin.getCompatability().sendTitle(p, Messages2.setPlaceholders(p, titleString[0]));
                if (titleString.length == 2) {
                    this.plugin.getCompatability().sendSubtitle(p, Messages2.setPlaceholders(p, titleString[1]));
                }
            }
        } else if (action.contains("[ActionBar]")) {
            action = Messages2.setPlaceholders(p, action.replace("[ActionBar] ", "").replace("[ActionBar]", ""));
            this.plugin.getCompatability().sendAction(p, Messages2.setPlaceholders(p, action));
        } else if (action.contains("[JSONMessage]")) {
            action = Messages2.setPlaceholders(p, action.replace("[JSONMessage] ", "").replace("[JSONMessage]", ""));
            this.plugin.getCompatability().sendJSONMessage(p, action);
        } else if (action.contains("[JSONBroadcast]")) {
            action = Messages2.setPlaceholders(p, action.replace("[JSONBroadcast] ", "").replace("[JSONBroadcast]", ""));
            this.plugin.getCompatability().sendJSONBroadcast(this.plugin.getServer().getOnlinePlayers(), action);
        } else if (action.contains("[Bungee]")) {
            action = Messages2.setPlaceholders(p, action.replace("[Bungee] ", "").replace("[Bungee]", ""));
            ByteArrayDataOutput out = ByteStreams.newDataOutput();
            out.writeUTF("Connect");
            out.writeUTF(action);
            p.sendPluginMessage((Plugin)this.plugin, "BungeeCord", out.toByteArray());
        }
    }
}

