package com.dbsoftware.pingapi;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.event.Event;
import org.bukkit.plugin.java.JavaPlugin;
import com.dbsoftware.pingapi.api.PingAPI;

/**
 * The Main class of the PingAPI.
 */
public class Pinger extends JavaPlugin {
	
	private static Pinger instance;
	private List<ServerInfo> servers = new ArrayList<ServerInfo>();
	private Ping ping;
	private PingAPI pingapi;
	
	public void onEnable(){
		instance = this;
		ping = new Ping(this);
		pingapi = new PingAPI();
	}
	
	/**
	 * Returns the API, to use the PingAPI.
	 */
	public PingAPI getPingAPI(){
		return pingapi;
	}
	
	public Ping getPinger(){
		return ping;
	}

	public static Pinger getInstance(){
		return instance;
	}

	/**
	 * Returns a list of all registered servers.
	 */
	public List<ServerInfo> getServers() {
		return servers;
	}
	
	public void callSyncEvent(final Event event){
		Bukkit.getScheduler().scheduleSyncDelayedTask(this, new Runnable(){
			@Override
			public void run(){
				getServer().getPluginManager().callEvent(event);
			}
		});
	}
}
