/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.particle;

import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.chat.hover.content.Content;
import net.md_5.bungee.api.chat.hover.content.Text;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public final class FancyMessageSender {
    private static final int MAJOR_VERSION_NUMBER = Integer.parseInt(Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3].split("_")[1]);

    private FancyMessageSender() {
    }

    public static void sendHoverableMessage(Player player, String message, String hover) throws Exception {
        TextComponent tc = new TextComponent();
        tc.setText(message);
        if (MAJOR_VERSION_NUMBER >= 16) {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hover)}));
        } else {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
        }
        player.spigot().sendMessage((BaseComponent)tc);
    }

    public static void sendHoverableCommandMessage(Player player, String message, String command, String hover) throws Exception {
        TextComponent tc = new TextComponent();
        tc.setText(message);
        tc.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, command));
        if (MAJOR_VERSION_NUMBER >= 16) {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new Content[]{new Text(hover)}));
        } else {
            tc.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, new ComponentBuilder(hover).create()));
        }
        player.spigot().sendMessage((BaseComponent)tc);
    }

    public static void sendActionBarMessage(Player player, String message) throws Exception {
        player.spigot().sendMessage(ChatMessageType.ACTION_BAR, TextComponent.fromLegacyText((String)message));
    }

    public static void sendTitle(Player player, String title, String subtitle) throws Exception {
        if (MAJOR_VERSION_NUMBER >= 11) {
            player.sendTitle(title, subtitle, 10, 70, 20);
        } else if (MAJOR_VERSION_NUMBER >= 8) {
            player.sendTitle(title, subtitle);
        }
    }
}

