/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.listener;

import com.gmail.filoghost.holographicdisplays.api.Hologram;
import com.gmail.filoghost.holographicdisplays.api.HologramsAPI;
import com.hm.mcshared.event.PlayerChangeAnimalOwnershipEvent;
import com.hm.petmaster.PetMaster;
import com.hm.petmaster.particle.FancyMessageSender;
import java.lang.reflect.Method;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.entity.AnimalTamer;
import org.bukkit.entity.Cat;
import org.bukkit.entity.Llama;
import org.bukkit.entity.Ocelot;
import org.bukkit.entity.Parrot;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sittable;
import org.bukkit.entity.Tameable;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.Wolf;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.scheduler.BukkitRunnable;

public class PlayerInteractListener
implements Listener {
    private static final double DOG_OFFSET = 1.5;
    private static final double CAT_OFFSET = 1.42;
    private static final double HORSE_OFFSET = 2.32;
    private static final double LLAMA_OFFSET = 2.42;
    private static final double PARROT_OFFSET = 1.15;
    private final PetMaster plugin;
    private Economy economy;
    private boolean chatMessage;
    private boolean hologramMessage;
    private boolean actionBarMessage;
    private boolean displayDog;
    private boolean displayCat;
    private boolean displayHorse;
    private boolean displayLlama;
    private boolean displayParrot;
    private boolean displayToOwner;
    private int hologramDuration;
    private int changeOwnerPrice;
    private int freePetPrice;
    private boolean showHealth;
    private boolean disableRiding;

    public PlayerInteractListener(PetMaster petMaster) {
        RegisteredServiceProvider rsp;
        this.plugin = petMaster;
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") != null && (rsp = Bukkit.getServer().getServicesManager().getRegistration(Economy.class)) != null) {
            this.economy = (Economy)rsp.getProvider();
        }
    }

    public void extractParameters() {
        this.displayDog = this.plugin.getPluginConfig().getBoolean("displayDog", true);
        this.displayCat = this.plugin.getPluginConfig().getBoolean("displayCat", true);
        this.displayHorse = this.plugin.getPluginConfig().getBoolean("displayHorse", true);
        this.displayLlama = this.plugin.getPluginConfig().getBoolean("displayLlama", true);
        this.displayParrot = this.plugin.getPluginConfig().getBoolean("displayParrot", true);
        this.displayToOwner = this.plugin.getPluginConfig().getBoolean("displayToOwner", false);
        this.hologramDuration = this.plugin.getPluginConfig().getInt("hologramDuration", 50);
        this.changeOwnerPrice = this.plugin.getPluginConfig().getInt("changeOwnerPrice", 0);
        this.freePetPrice = this.plugin.getPluginConfig().getInt("freePetPrice", 0);
        this.chatMessage = this.plugin.getPluginConfig().getBoolean("chatMessage", true);
        this.hologramMessage = this.plugin.getPluginConfig().getBoolean("hologramMessage", false);
        this.actionBarMessage = this.plugin.getPluginConfig().getBoolean("actionBarMessage", true);
        this.showHealth = this.plugin.getPluginConfig().getBoolean("showHealth", true);
        this.disableRiding = this.plugin.getPluginConfig().getBoolean("disableRiding", false);
        boolean holographicDisplaysAvailable = Bukkit.getPluginManager().isPluginEnabled("HolographicDisplays");
        if (this.hologramMessage && !holographicDisplaysAvailable) {
            this.hologramMessage = false;
            this.actionBarMessage = true;
            this.plugin.getLogger().warning("HolographicDisplays was not found; disabling usage of holograms and enabling action bar messages.");
        }
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent event) {
        if (this.shouldHandleEvent(event)) {
            Tameable tameable = (Tameable)event.getRightClicked();
            AnimalTamer currentOwner = tameable.getOwner();
            if (currentOwner == null || currentOwner.getName() == null) {
                return;
            }
            Player player = event.getPlayer();
            boolean isOwner = player.getUniqueId().equals(currentOwner.getUniqueId());
            Player newOwner = this.plugin.getSetOwnerCommand().collectPendingSetOwnershipRequest(player);
            boolean freePet = this.plugin.getFreeCommand().collectPendingFreeRequest(player);
            if (this.disableRiding && !isOwner && !player.hasPermission("petmaster.admin") && tameable instanceof Vehicle) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("not-owner", "You do not own this pet!"));
                event.setCancelled(true);
                return;
            }
            if (!(newOwner == null && !freePet || isOwner || player.hasPermission("petmaster.admin"))) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("not-owner", "You do not own this pet!"));
                return;
            }
            if (newOwner != null) {
                this.changeOwner(player, currentOwner, newOwner, tameable);
            } else if (freePet) {
                this.freePet(player, currentOwner, tameable);
            } else if ((this.displayToOwner || !isOwner) && player.hasPermission("petmaster.showowner.*")) {
                this.displayHologramAndMessage(player, currentOwner, tameable);
            }
        }
    }

    private boolean shouldHandleEvent(PlayerInteractEntityEvent event) {
        return !this.plugin.getEnableDisableCommand().isDisabled() && event.getRightClicked() instanceof Tameable && (this.plugin.getServerVersion() < 9 || event.getHand() == EquipmentSlot.HAND);
    }

    private void changeOwner(Player player, AnimalTamer oldOwner, Player newOwner, Tameable tameable) {
        if (this.chargePrice(player, this.changeOwnerPrice)) {
            tameable.setOwner((AnimalTamer)newOwner);
            player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("owner-changed", "This pet was given to a new owner!"));
            newOwner.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("new-owner", "Player PLAYER gave you ownership of a pet!").replace("PLAYER", player.getName()));
            PlayerChangeAnimalOwnershipEvent playerChangeAnimalOwnershipEvent = new PlayerChangeAnimalOwnershipEvent(oldOwner, (AnimalTamer)newOwner, tameable);
            Bukkit.getServer().getPluginManager().callEvent((Event)playerChangeAnimalOwnershipEvent);
        }
    }

    private void freePet(Player player, AnimalTamer oldOwner, Tameable tameable) {
        if (this.chargePrice(player, this.freePetPrice)) {
            tameable.setTamed(false);
            if (this.plugin.getServerVersion() >= 12 && tameable instanceof Sittable) {
                ((Sittable)tameable).setSitting(false);
            } else if (tameable instanceof Wolf) {
                ((Wolf)tameable).setSitting(false);
            } else if (tameable instanceof Ocelot) {
                try {
                    Method setSitting = Ocelot.class.getMethod("setSitting", Boolean.TYPE);
                    setSitting.invoke((Object)tameable, false);
                }
                catch (ReflectiveOperationException e) {
                    this.plugin.getLogger().warning("Failed to make freed ocelot stand up.");
                }
            }
            player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("pet-freed", "Say goodbye: this pet returned to the wild!"));
            PlayerChangeAnimalOwnershipEvent playerChangeAnimalOwnershipEvent = new PlayerChangeAnimalOwnershipEvent(oldOwner, null, tameable);
            Bukkit.getServer().getPluginManager().callEvent((Event)playerChangeAnimalOwnershipEvent);
        }
    }

    private void displayHologramAndMessage(Player player, AnimalTamer owner, Tameable tameable) {
        if (this.hologramMessage) {
            int version = this.plugin.getServerVersion();
            double offset = 2.32;
            if (tameable instanceof Ocelot || version >= 14 && tameable instanceof Cat) {
                if (!this.displayCat || !player.hasPermission("petmaster.showowner.cat")) {
                    return;
                }
                offset = 1.42;
            } else if (tameable instanceof Wolf) {
                if (!this.displayDog || !player.hasPermission("petmaster.showowner.dog")) {
                    return;
                }
                offset = 1.5;
            } else if (version >= 11 && tameable instanceof Llama) {
                if (!this.displayLlama || !player.hasPermission("petmaster.showowner.llama")) {
                    return;
                }
                offset = 2.42;
            } else if (version >= 12 && tameable instanceof Parrot) {
                if (!this.displayParrot || !player.hasPermission("petmaster.showowner.parrot")) {
                    return;
                }
                offset = 1.15;
            } else if (!(!(tameable instanceof Vehicle) || this.displayHorse && player.hasPermission("petmaster.showowner.horse"))) {
                return;
            }
            Location eventLocation = tameable.getLocation();
            Location hologramLocation = new Location(eventLocation.getWorld(), eventLocation.getX(), eventLocation.getY() + offset, eventLocation.getZ());
            final Hologram hologram = HologramsAPI.createHologram((Plugin)this.plugin, (Location)hologramLocation);
            hologram.appendTextLine(ChatColor.GRAY + this.plugin.getPluginLang().getString("petmaster-hologram", "Pet owned by ") + ChatColor.GOLD + owner.getName());
            new BukkitRunnable(){

                public void run() {
                    hologram.delete();
                }
            }.runTaskLater((Plugin)this.plugin, (long)this.hologramDuration);
        }
        String healthInfo = "";
        if (this.showHealth) {
            Tameable animal = tameable;
            String currentHealth = String.format("%.1f", animal.getHealth());
            String maxHealth = this.plugin.getServerVersion() < 9 ? String.format("%.1f", animal.getMaxHealth()) : String.format("%.1f", animal.getAttribute(Attribute.GENERIC_MAX_HEALTH).getValue());
            healthInfo = ChatColor.GRAY + ". " + this.plugin.getPluginLang().getString("petmaster-health", "Health: ") + ChatColor.GOLD + currentHealth + "/" + maxHealth;
        }
        if (this.chatMessage) {
            player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("petmaster-chat", "Pet owned by ") + ChatColor.GOLD + owner.getName() + healthInfo);
        }
        if (this.actionBarMessage) {
            try {
                FancyMessageSender.sendActionBarMessage(player, "\u00a7o" + ChatColor.GRAY + this.plugin.getPluginLang().getString("petmaster-action-bar", "Pet owned by ") + ChatColor.GOLD + owner.getName() + healthInfo);
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("Errors while trying to display action bar message for pet ownership.");
            }
        }
    }

    private boolean chargePrice(Player player, int price) {
        if (price > 0 && !player.hasPermission("petmaster.admin") && this.economy != null) {
            String priceWithCurrency = price + " " + (price > 1 ? this.economy.currencyNamePlural() : this.economy.currencyNameSingular());
            if (this.economy.getBalance((OfflinePlayer)player) < (double)price) {
                player.sendMessage(this.plugin.getChatHeader() + ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getPluginLang().getString("not-enough-money", "You do not have the required amount: AMOUNT!").replace("AMOUNT", priceWithCurrency)));
                return false;
            }
            this.economy.withdrawPlayer((OfflinePlayer)player, (double)price);
            player.sendMessage(this.plugin.getChatHeader() + ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getPluginLang().getString("change-owner-price", "You payed: AMOUNT!").replace("AMOUNT", priceWithCurrency)));
        }
        return true;
    }
}

