/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.listener;

import com.hm.petmaster.PetMaster;
import org.bukkit.entity.Creature;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.Tameable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;

public class PlayerAttackListener
implements Listener {
    private final PetMaster plugin;
    private boolean enableAngryMobPlayerDamage;

    public PlayerAttackListener(PetMaster plugin) {
        this.plugin = plugin;
    }

    public void extractParameters() {
        this.enableAngryMobPlayerDamage = this.plugin.getPluginConfig().getBoolean("enableAngryMobPlayerDamage", true);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerDamagePet(EntityDamageByEntityEvent event) {
        if (this.plugin.getEnableDisableCommand().isDisabled()) {
            return;
        }
        Entity damager = event.getDamager();
        Entity damaged = event.getEntity();
        if (!this.isDamagerProjectileOrPlayer(damager) || !this.isDamagedOwned(damaged)) {
            return;
        }
        if (damager instanceof Projectile) {
            damager = (Entity)((Projectile)damager).getShooter();
        }
        if (this.isDamagerPlayerDifferentFromDamagedOwner(damager, damaged)) {
            event.setCancelled(!this.enableAngryMobPlayerDamage || !this.isDamagedTargettingDamager(damager, damaged));
        }
    }

    private boolean isDamagerProjectileOrPlayer(Entity damager) {
        return damager instanceof Projectile || damager instanceof Player;
    }

    private boolean isDamagedOwned(Entity damaged) {
        return damaged instanceof Tameable && ((Tameable)damaged).getOwner() != null;
    }

    private boolean isDamagerPlayerDifferentFromDamagedOwner(Entity damager, Entity damaged) {
        return damager instanceof Player && !((Tameable)damaged).getOwner().getUniqueId().equals(damager.getUniqueId());
    }

    private boolean isDamagedTargettingDamager(Entity damager, Entity damaged) {
        if (damaged instanceof Creature) {
            Creature creature = (Creature)damaged;
            return creature.getTarget() != null && creature.getTarget().getUniqueId().equals(damager.getUniqueId());
        }
        return false;
    }
}

