/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.file;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import org.bukkit.plugin.java.JavaPlugin;

public class FileManager {
    private final JavaPlugin plugin;
    private final String pluginResourceName;
    private File file;
    private int numOfComments;

    public FileManager(String fileName, JavaPlugin plugin) {
        this(fileName, fileName, plugin);
    }

    public FileManager(String fileName, String pluginResourceName, JavaPlugin plugin) {
        this.plugin = plugin;
        this.pluginResourceName = pluginResourceName;
        this.file = fileName.startsWith("/") ? new File(plugin.getDataFolder() + fileName.replace("/", File.separator)) : new File(plugin.getDataFolder() + File.separator + fileName.replace("/", File.separator));
    }

    public void backupFile() throws IOException {
        File backupFile = new File(this.plugin.getDataFolder(), this.file.getName() + ".bak");
        if (this.file.lastModified() > backupFile.lastModified() && this.file.exists()) {
            try (FileInputStream inStream = new FileInputStream(this.file);
                 FileOutputStream outStream = new FileOutputStream(backupFile);){
                int length;
                byte[] buffer = new byte[1024];
                while ((length = inStream.read(buffer)) > 0) {
                    outStream.write(buffer, 0, length);
                }
            }
        }
    }

    protected String getConfigurationWithReworkedComments() throws IOException {
        StringBuilder reworkedConfiguration = new StringBuilder();
        try (FileInputStream fileInputStream = new FileInputStream(this.file);){
            String string;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "UTF-8"));){
                String currentLine;
                this.numOfComments = 0;
                while ((currentLine = bufferedReader.readLine()) != null) {
                    if (currentLine.startsWith("#")) {
                        reworkedConfiguration.append(currentLine.replace(":", "_COLON_").replace("|", "_VERT_").replace("-", "_HYPHEN_").replace(" ", "_SPACE_").replaceFirst("#", this.plugin.getDescription().getName() + "_COMMENT_" + this.numOfComments + ": "));
                        ++this.numOfComments;
                    } else {
                        reworkedConfiguration.append(currentLine);
                    }
                    reworkedConfiguration.append("\n");
                }
                string = reworkedConfiguration.toString();
            }
            return string;
        }
    }

    protected int getNumberOfComments() {
        return this.numOfComments;
    }

    protected void saveConfiguration(String configString) throws IOException {
        String configuration = this.getConfigurationWithRegeneratedComments(configString);
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.file);
             OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)fileOutputStream, "UTF-8");
             BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);){
            bufferedWriter.write(configuration);
            bufferedWriter.flush();
        }
    }

    protected void createConfigurationFileIfNotExists() throws IOException {
        this.file.getParentFile().mkdirs();
        if (this.file.createNewFile()) {
            try (FileOutputStream outputStream = new FileOutputStream(this.file);){
                InputStream resource = this.plugin.getResource(this.pluginResourceName);
                if (resource != null) {
                    int length;
                    byte[] buf = new byte[1024];
                    while ((length = resource.read(buf)) > 0) {
                        ((OutputStream)outputStream).write(buf, 0, length);
                    }
                }
            }
            this.plugin.getLogger().info("Successfully created " + this.file.getName() + " file.");
        }
    }

    private String getConfigurationWithRegeneratedComments(String configString) {
        boolean previousLineComment = false;
        String[] lines = configString.split("\n");
        StringBuilder config = new StringBuilder();
        for (String line : lines) {
            if (line.startsWith(this.plugin.getDescription().getName() + "_COMMENT")) {
                String comment = ("#" + line.substring(line.indexOf(": ") + 2)).replace("_COLON_", ":").replace("_HYPHEN_", "-").replace("_VERT_", "|").replace("_SPACE_", " ");
                if (previousLineComment) {
                    config.append(comment + "\n");
                } else {
                    config.append("\n" + comment + "\n");
                }
                previousLineComment = true;
                continue;
            }
            config.append(line + "\n");
            previousLineComment = false;
        }
        return config.toString();
    }
}

