/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.command;

import com.hm.petmaster.PetMaster;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class SetOwnerCommand {
    private final PetMaster plugin;
    private final Map<UUID, Player> changeOwnershipMap;

    public SetOwnerCommand(PetMaster plugin) {
        this.plugin = plugin;
        this.changeOwnershipMap = new HashMap<UUID, Player>();
    }

    public void setOwner(Player player, String[] args) {
        if (args.length == 2) {
            Player newOwner = null;
            for (Player currentPlayer : Bukkit.getOnlinePlayers()) {
                if (!currentPlayer.getName().equalsIgnoreCase(args[1])) continue;
                newOwner = currentPlayer;
                break;
            }
            if (newOwner == null) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("player-offline", "The specified player is offline!"));
            } else if (!player.hasPermission("petmaster.setowner")) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("no-permissions", "You do not have the permission to do this."));
            } else if (this.plugin.getEnableDisableCommand().isDisabled()) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("currently-disabled", "PetMaster is currently disabled, you cannot use this command."));
            } else if (!player.hasPermission("petmaster.admin") && newOwner.getUniqueId().equals(player.getUniqueId())) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("cannot-change-to-yourself", "You cannot change the owner to yourself!"));
            } else {
                this.changeOwnershipMap.put(player.getUniqueId(), newOwner);
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("right-click", "Right click on a pet to change its owner!"));
                this.plugin.getFreeCommand().collectPendingFreeRequest(player);
            }
        } else {
            player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("misused-command", "Misused command. Please type /petm."));
        }
    }

    public Player collectPendingSetOwnershipRequest(Player player) {
        return this.changeOwnershipMap.remove(player.getUniqueId());
    }
}

