/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.command;

import com.hm.petmaster.PetMaster;
import java.io.File;
import java.io.IOException;
import java.util.UUID;
import java.util.logging.Level;
import org.bukkit.DyeColor;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class SetColorCommand {
    private static final String COLOR_CONFIG_NAME = "color";
    private final PetMaster plugin;
    private final File playerColorConfig;

    public SetColorCommand(PetMaster plugin, File playerColorConfig) {
        this.plugin = plugin;
        this.playerColorConfig = playerColorConfig;
    }

    public void setColor(Player player, String[] args) {
        if (args.length != 2) {
            player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("misused-command", "Misused command. Please type /petm."));
            return;
        }
        try {
            DyeColor color = DyeColor.valueOf((String)args[1].toUpperCase());
            if (!player.hasPermission("petmaster.setcolor")) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("no-permissions", "You do not have the permission to do this."));
            } else if (this.plugin.getEnableDisableCommand().isDisabled()) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("currently-disabled", "PetMaster is currently disabled, you cannot use this command."));
            } else {
                try {
                    YamlConfiguration config;
                    ConfigurationSection playerConfig;
                    if (!this.playerColorConfig.exists()) {
                        this.playerColorConfig.createNewFile();
                    }
                    if ((playerConfig = (config = YamlConfiguration.loadConfiguration((File)this.playerColorConfig)).getConfigurationSection(player.getUniqueId().toString())) == null) {
                        playerConfig = config.createSection(player.getUniqueId().toString());
                    }
                    playerConfig.set(COLOR_CONFIG_NAME, (Object)color.toString());
                    config.save(this.playerColorConfig);
                    player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("color-successfully-set", "Color successfully changed."));
                }
                catch (IOException e) {
                    this.plugin.getLogger().severe("Error while loading " + this.playerColorConfig.getName());
                    this.plugin.getLogger().log(Level.SEVERE, "Verify your syntax by visiting yaml-online-parser.appspot.com and using the following logs: ", e);
                }
            }
        }
        catch (IllegalArgumentException ex) {
            StringBuilder colors = new StringBuilder();
            int length = DyeColor.values().length;
            for (int i = 0; i < length; ++i) {
                DyeColor color = DyeColor.values()[i];
                colors.append(color.name().toLowerCase());
                if (i >= length - 1) continue;
                colors.append(' ');
            }
            player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("available-colors", "The following colors are available: ") + colors.toString());
        }
    }

    public DyeColor getColor(UUID player) {
        String color;
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)this.playerColorConfig);
        ConfigurationSection playerConfig = config.getConfigurationSection(player.toString());
        if (playerConfig != null && (color = playerConfig.getString(COLOR_CONFIG_NAME)) != null) {
            return DyeColor.valueOf((String)color);
        }
        return DyeColor.RED;
    }
}

