/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.command;

import com.hm.petmaster.PetMaster;
import com.hm.petmaster.particle.FancyMessageSender;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class HelpCommand {
    private final PetMaster plugin;

    public HelpCommand(PetMaster plugin) {
        this.plugin = plugin;
    }

    public void getHelp(CommandSender sender) {
        sender.sendMessage(ChatColor.GOLD + "------------------ " + ChatColor.GRAY + ChatColor.GOLD + "\u265e" + ChatColor.translateAlternateColorCodes((char)'&', (String)" &lPet Master ") + ChatColor.GOLD + "\u265e" + ChatColor.GRAY + ChatColor.GOLD + " ------------------");
        this.sendJsonClickableHoverableMessage(sender, this.plugin.getChatHeader() + ChatColor.GOLD + "/petm info" + ChatColor.GRAY + " > " + this.plugin.getPluginLang().getString("petmaster-command-info", "Display various information about the plugin."), "/petm info", this.plugin.getPluginLang().getString("petmaster-command-info-hover", "Some extra info about the plugin and its awesome author!"));
        if (sender.hasPermission("petmaster.free")) {
            this.sendJsonClickableHoverableMessage(sender, this.plugin.getChatHeader() + ChatColor.GOLD + "/petm free" + ChatColor.GRAY + " > " + this.plugin.getPluginLang().getString("petmaster-command-free", "Free a pet."), "/petm free", this.plugin.getPluginLang().getString("petmaster-command-free-hover", "You can only free your own pets, unless you're admin!"));
        }
        if (sender.hasPermission("petmaster.admin")) {
            this.sendJsonClickableHoverableMessage(sender, this.plugin.getChatHeader() + ChatColor.GOLD + "/petm reload" + ChatColor.GRAY + " > " + this.plugin.getPluginLang().getString("petmaster-command-reload", "Reload the plugin's configuration."), "/petm reload", this.plugin.getPluginLang().getString("petmaster-command-reload-hover", "Reload most settings in config.yml and lang.yml files."));
            this.sendJsonClickableHoverableMessage(sender, this.plugin.getChatHeader() + ChatColor.GOLD + "/petm enable" + ChatColor.GRAY + " > " + this.plugin.getPluginLang().getString("petmaster-command-enable", "Enable plugin."), "/petm enable", this.plugin.getPluginLang().getString("petmaster-command-enable-hover", "Plugin enabled by default. Use this if you entered /petm disable before!"));
            this.sendJsonClickableHoverableMessage(sender, this.plugin.getChatHeader() + ChatColor.GOLD + "/petm disable" + ChatColor.GRAY + " > " + this.plugin.getPluginLang().getString("petmaster-command-disable", "Disable plugin."), "/petm disable", this.plugin.getPluginLang().getString("petmaster-command-disable-hover", "The plugin will not work until next reload or /petm enable."));
        }
        if (sender.hasPermission("petmaster.setowner")) {
            this.sendJsonClickableHoverableMessage(sender, this.plugin.getChatHeader() + ChatColor.GOLD + "/petm setowner \u00a7oPLAYER\u00a7r" + ChatColor.GRAY + " > " + this.plugin.getPluginLang().getString("petmaster-command-setowner", "Change the ownership of a pet."), "/petm setowner PLAYER", this.plugin.getPluginLang().getString("petmaster-command-setowner-hover", "You can only change the ownership of your own pets, unless you're admin!"));
        }
        if (sender.hasPermission("petmaster.setcolor")) {
            this.sendJsonClickableHoverableMessage(sender, this.plugin.getChatHeader() + ChatColor.GOLD + "/petm setcolor \u00a7oCOLOR\u00a7r" + ChatColor.GRAY + " > " + this.plugin.getPluginLang().getString("petmaster-command-setcolor", "Set the color of the collars of all pets tamed in the future."), "/petm setcolor COLOR", this.plugin.getPluginLang().getString("petmaster-command-setcolor-hover", "Currently tamed pets are unaffected."));
        }
        sender.sendMessage(ChatColor.GOLD + " ");
        sender.sendMessage(ChatColor.GRAY + ChatColor.translateAlternateColorCodes((char)'&', (String)this.plugin.getPluginLang().getString("petmaster-tip", "&lHINT&r &8You can &7&n&ohover&r &8or &7&n&oclick&r &8on the commands!")));
    }

    public void sendJsonClickableHoverableMessage(CommandSender sender, String message, String command, String hover) {
        if (sender instanceof Player) {
            try {
                FancyMessageSender.sendHoverableCommandMessage((Player)sender, message, command, hover);
            }
            catch (Exception ex) {
                this.plugin.getLogger().severe("Errors while trying to display clickable and hoverable message in /petm help command. Displaying standard message instead.");
                sender.sendMessage(message);
            }
        } else {
            sender.sendMessage(message);
        }
    }
}

