/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster.command;

import com.hm.petmaster.PetMaster;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.bukkit.entity.Player;

public class FreeCommand {
    private final PetMaster plugin;
    private final Set<UUID> freePetSet;

    public FreeCommand(PetMaster plugin) {
        this.plugin = plugin;
        this.freePetSet = new HashSet<UUID>();
    }

    public void freePet(Player player, String[] args) {
        if (args.length == 1) {
            if (!player.hasPermission("petmaster.free")) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("no-permissions", "You do not have the permission to do this."));
            } else if (this.plugin.getEnableDisableCommand().isDisabled()) {
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("currently-disabled", "PetMaster is currently disabled, you cannot use this command."));
            } else {
                this.freePetSet.add(player.getUniqueId());
                player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("right-click", "Right click on a pet to change its owner!"));
                this.plugin.getSetOwnerCommand().collectPendingSetOwnershipRequest(player);
            }
        } else {
            player.sendMessage(this.plugin.getChatHeader() + this.plugin.getPluginLang().getString("misused-command", "Misused command. Please type /petm."));
        }
    }

    public boolean collectPendingFreeRequest(Player player) {
        return this.freePetSet.remove(player.getUniqueId());
    }
}

