/*
 * Decompiled with CFR 0.152.
 */
package com.hm.petmaster;

import com.hm.petmaster.command.EnableDisableCommand;
import com.hm.petmaster.command.FreeCommand;
import com.hm.petmaster.command.HelpCommand;
import com.hm.petmaster.command.InfoCommand;
import com.hm.petmaster.command.PetInvincibleCommand;
import com.hm.petmaster.command.PetSkillCommand;
import com.hm.petmaster.command.ReloadCommand;
import com.hm.petmaster.command.SetColorCommand;
import com.hm.petmaster.command.SetOwnerCommand;
import com.hm.petmaster.command.ShareCommand;
import com.hm.petmaster.file.CommentedYamlConfiguration;
import com.hm.petmaster.files.PetAbilityFile;
import com.hm.petmaster.listener.PlayerAttackListener;
import com.hm.petmaster.listener.PlayerBreedListener;
import com.hm.petmaster.listener.PlayerInteractListener;
import com.hm.petmaster.listener.PlayerLeashListener;
import com.hm.petmaster.listener.PlayerQuitListener;
import com.hm.petmaster.listener.PlayerTameListener;
import com.hm.petmaster.update.UpdateChecker;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class PetMaster
extends JavaPlugin {
    private String chatHeader;
    private boolean updatePerformed;
    private int serverVersion;
    private CommentedYamlConfiguration config;
    private CommentedYamlConfiguration lang;
    private PlayerInteractListener playerInteractListener;
    private PlayerLeashListener playerLeashListener;
    private PlayerQuitListener playerQuitListener;
    private PlayerAttackListener playerAttackListener;
    private PlayerTameListener playerTameListener;
    private PlayerBreedListener playerBreedListener;
    private UpdateChecker updateChecker;
    private HelpCommand helpCommand;
    private InfoCommand infoCommand;
    private SetOwnerCommand setOwnerCommand;
    private FreeCommand freeCommand;
    private EnableDisableCommand enableDisableCommand;
    private ReloadCommand reloadCommand;
    private SetColorCommand setColorCommand;
    private ShareCommand shareCommand;
    private PetInvincibleCommand petInvincibleCommand;
    private PetSkillCommand petSkillCommand;

    public void onEnable() {
        long startTime = System.currentTimeMillis();
        this.getLogger().info("Registering listeners...");
        this.serverVersion = Integer.parseInt(Bukkit.getServer().getClass().getPackage().getName().replace(".", ",").split(",")[3].split("_")[1]);
        this.playerInteractListener = new PlayerInteractListener(this);
        this.playerLeashListener = new PlayerLeashListener(this);
        this.playerQuitListener = new PlayerQuitListener(this);
        this.playerTameListener = new PlayerTameListener(this);
        this.playerBreedListener = new PlayerBreedListener(this);
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)this.playerInteractListener, (Plugin)this);
        pm.registerEvents((Listener)this.playerLeashListener, (Plugin)this);
        pm.registerEvents((Listener)this.playerQuitListener, (Plugin)this);
        pm.registerEvents((Listener)this.playerTameListener, (Plugin)this);
        if (this.getServerVersion() >= 10) {
            pm.registerEvents((Listener)this.playerBreedListener, (Plugin)this);
        }
        this.extractParametersFromConfig(true);
        PetAbilityFile.petAbilitySetup();
        PetAbilityFile.getPetAbilities().options().copyDefaults(true);
        PetAbilityFile.petAbilitySave();
        this.chatHeader = ChatColor.GRAY + "[" + ChatColor.GOLD + "\u265e" + ChatColor.GRAY + "] ";
        File playerColorConfig = new File(this.getDataFolder() + File.separator + "playersettings.yml");
        this.helpCommand = new HelpCommand(this);
        this.infoCommand = new InfoCommand(this);
        this.setOwnerCommand = new SetOwnerCommand(this);
        this.freeCommand = new FreeCommand(this);
        this.enableDisableCommand = new EnableDisableCommand(this);
        this.reloadCommand = new ReloadCommand(this);
        this.setColorCommand = new SetColorCommand(this, playerColorConfig);
        this.shareCommand = new ShareCommand(this);
        this.petInvincibleCommand = new PetInvincibleCommand(this);
        this.petSkillCommand = new PetSkillCommand(this);
        if (this.getServer().getPluginManager().isPluginEnabled((Plugin)this)) {
            this.getLogger().info("Plugin enabled and ready to run! Took " + (System.currentTimeMillis() - startTime) + "ms.");
        }
    }

    public void extractParametersFromConfig(boolean attemptUpdate) {
        this.getLogger().info("Backing up and loading configuration files...");
        this.config = this.loadAndBackupYamlConfiguration("config.yml");
        this.lang = this.loadAndBackupYamlConfiguration(this.config.getString("languageFileName", "lang.yml"));
        if (!this.getServer().getPluginManager().isPluginEnabled((Plugin)this)) {
            return;
        }
        if (attemptUpdate) {
            this.updateOldConfiguration();
            this.updateOldLanguage();
        }
        this.playerInteractListener.extractParameters();
        this.playerLeashListener.extractParameters();
        if (this.config.getBoolean("checkForUpdate", true)) {
            if (this.updateChecker == null) {
                this.updateChecker = new UpdateChecker(this, "https://raw.githubusercontent.com/PyvesB/PetMaster/master/pom.xml", "petmaster.admin", this.chatHeader, "spigotmc.org/resources/pet-master.15904");
                this.getServer().getPluginManager().registerEvents((Listener)this.updateChecker, (Plugin)this);
                this.updateChecker.launchUpdateCheckerTask();
            }
        } else {
            PlayerJoinEvent.getHandlerList().unregister((Listener)this.updateChecker);
            this.updateChecker = null;
        }
        if (this.config.getBoolean("disablePlayerDamage", false)) {
            if (this.playerAttackListener == null) {
                this.playerAttackListener = new PlayerAttackListener(this);
                this.getServer().getPluginManager().registerEvents((Listener)this.playerAttackListener, (Plugin)this);
                this.playerAttackListener.extractParameters();
            }
        } else if (this.playerAttackListener != null) {
            HandlerList.unregisterAll((Listener)this.playerAttackListener);
            this.playerAttackListener = null;
        }
    }

    private CommentedYamlConfiguration loadAndBackupYamlConfiguration(String fileName) {
        CommentedYamlConfiguration yamlConfiguration = new CommentedYamlConfiguration(fileName, this);
        try {
            yamlConfiguration.loadConfiguration();
        }
        catch (IOException | InvalidConfigurationException e) {
            this.getLogger().severe("Error while loading " + fileName + " file, disabling plugin.");
            this.getLogger().log(Level.SEVERE, "Verify your syntax by visiting yaml-online-parser.appspot.com and using the following logs: ", e);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
        try {
            yamlConfiguration.backupConfiguration();
        }
        catch (IOException e) {
            this.getLogger().log(Level.SEVERE, "Error while backing up configuration file: ", e);
        }
        return yamlConfiguration;
    }

    private void updateOldConfiguration() {
        this.updatePerformed = false;
        this.updateSetting(this.config, "languageFileName", "lang.yml", "Name of the language file.");
        this.updateSetting(this.config, "checkForUpdate", true, "Check for update on plugin launch and notify when an OP joins the game.");
        this.updateSetting(this.config, "changeOwnerPrice", 0, "Price of the /petm setowner command (requires Vault).");
        this.updateSetting(this.config, "displayDog", true, "Take dogs into account.");
        this.updateSetting(this.config, "displayCat", true, "Take cats into account.");
        this.updateSetting(this.config, "displayHorse", true, "Take horses into account.");
        this.updateSetting(this.config, "displayLlama", true, "Take llamas into account.");
        this.updateSetting(this.config, "displayParrot", true, "Take parrots into account.");
        this.updateSetting(this.config, "actionBarMessage", false, "Enable or disable action bar messages when right-clicking on a pet.");
        this.updateSetting(this.config, "displayToOwner", false, "Enable or disable showing ownership information for a player's own pets.");
        this.updateSetting(this.config, "freePetPrice", 0, "Price of the /petm free command (requires Vault).");
        this.updateSetting(this.config, "showHealth", true, "Show health next to owner in chat and action bar messages (not holograms).");
        this.updateSetting(this.config, "disablePlayerDamage", false, "Protect pets to avoid being hurt by other player.");
        this.updateSetting(this.config, "enableAngryMobPlayerDamage", true, "Allows players to defend themselves against angry tamed mobs (e.g. dogs) even if disablePlayerDamage is true.");
        this.updateSetting(this.config, "disableLeash", false, "Prevent others from using leash on pet.");
        this.updateSetting(this.config, "disableRiding", false, "Prevent others from mounting pet (horse/donkey).");
        if (this.updatePerformed) {
            try {
                this.config.saveConfiguration();
                this.config.loadConfiguration();
            }
            catch (IOException | InvalidConfigurationException e) {
                this.getLogger().log(Level.SEVERE, "Error while saving changes to the configuration file: ", e);
            }
        }
    }

    private void updateOldLanguage() {
        this.updatePerformed = false;
        this.updateSetting(this.lang, "petmaster-command-setowner-hover", "You can only change the ownership of your own pets, unless you're admin!", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-disable-hover", "The plugin will not work until next reload or /petm enable.", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-enable-hover", "Plugin enabled by default. Use this if you entered /petm disable before!", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-reload-hover", "Reload most settings in config.yml and lang.yml files.", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-info-hover", "Some extra info about the plugin and its awesome author!", new String[0]);
        this.updateSetting(this.lang, "petmaster-tip", "&lHINT&r &8You can &7&n&ohover&r &8or &7&n&oclick&r &8on the commands!", new String[0]);
        this.updateSetting(this.lang, "change-owner-price", "You payed: AMOUNT!", new String[0]);
        this.updateSetting(this.lang, "petmaster-action-bar", "Pet owned by ", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-free", "Free a pet.", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-free-hover", "You can only free your own pets, unless you're admin!", new String[0]);
        this.updateSetting(this.lang, "pet-freed", "Say goodbye: this pet returned to the wild!", new String[0]);
        this.updateSetting(this.lang, "not-enough-money", "You do not have the required amount: AMOUNT!", new String[0]);
        this.updateSetting(this.lang, "currently-disabled", "PetMaster is currently disabled, you cannot use this command.", new String[0]);
        this.updateSetting(this.lang, "petmaster-health", "Health: ", new String[0]);
        this.updateSetting(this.lang, "available-colors", "The following colors are available: ", new String[0]);
        this.updateSetting(this.lang, "color-successfully-set", "Color successfully changed.", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-setcolor", "Set the color of the collars of all pets tamed in the future.", new String[0]);
        this.updateSetting(this.lang, "petmaster-command-setcolor-hover", "Currently tamed pets are unaffected.", new String[0]);
        if (this.updatePerformed) {
            try {
                this.lang.saveConfiguration();
                this.lang.loadConfiguration();
            }
            catch (IOException | InvalidConfigurationException e) {
                this.getLogger().log(Level.SEVERE, "Error while saving changes to the language file: ", e);
            }
        }
    }

    public void onDisable() {
        this.getLogger().info("PetMaster has been disabled.");
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        if (!"petm".equalsIgnoreCase(cmd.getName())) {
            return false;
        }
        if (args.length == 0 || args.length == 1 && "help".equalsIgnoreCase(args[0])) {
            this.helpCommand.getHelp(sender);
        } else if ("info".equalsIgnoreCase(args[0])) {
            this.infoCommand.getInfo(sender);
        } else if ("reload".equalsIgnoreCase(args[0])) {
            this.reloadCommand.reload(sender);
        } else if ("disable".equalsIgnoreCase(args[0])) {
            this.enableDisableCommand.setState(sender, true);
        } else if ("enable".equalsIgnoreCase(args[0])) {
            this.enableDisableCommand.setState(sender, false);
        } else if ("setowner".equalsIgnoreCase(args[0]) && sender instanceof Player) {
            this.setOwnerCommand.setOwner((Player)sender, args);
        } else if ("free".equalsIgnoreCase(args[0]) && sender instanceof Player) {
            this.freeCommand.freePet((Player)sender, args);
        } else if ("setcolor".equalsIgnoreCase(args[0]) && sender instanceof Player) {
            this.setColorCommand.setColor((Player)sender, args);
        } else if ("sharepet".equalsIgnoreCase(args[0]) && sender instanceof Player) {
            this.shareCommand.sharePetCommand((CommandSender)((Player)sender));
        } else if ("godpet".equalsIgnoreCase(args[0]) && sender instanceof Player) {
            this.petInvincibleCommand.godPetCommand((CommandSender)((Player)sender));
        } else if ("petskill".equalsIgnoreCase(args[0]) && sender instanceof Player) {
            this.petSkillCommand.petSkillCommand((CommandSender)((Player)sender));
        } else {
            sender.sendMessage(this.chatHeader + this.lang.getString("misused-command", "Misused command. Please type /petm."));
        }
        return true;
    }

    private void updateSetting(CommentedYamlConfiguration file, String name, Object value, String ... comments) {
        if (!file.getKeys(false).contains(name)) {
            file.set(name, value, comments);
            this.updatePerformed = true;
        }
    }

    public int getServerVersion() {
        return this.serverVersion;
    }

    public String getChatHeader() {
        return this.chatHeader;
    }

    public CommentedYamlConfiguration getPluginConfig() {
        return this.config;
    }

    public CommentedYamlConfiguration getPluginLang() {
        return this.lang;
    }

    public SetOwnerCommand getSetOwnerCommand() {
        return this.setOwnerCommand;
    }

    public FreeCommand getFreeCommand() {
        return this.freeCommand;
    }

    public EnableDisableCommand getEnableDisableCommand() {
        return this.enableDisableCommand;
    }

    public SetColorCommand getSetColorCommand() {
        return this.setColorCommand;
    }
}

