/*
 * Decompiled with CFR 0.152.
 */
package easyrecipes;

import easyrecipes.events.inventory.InventoryClick;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.ShapedRecipe;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginDescriptionFile;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class EasyRecipesPlugin
extends JavaPlugin {
    private ArrayList<ShapedRecipe> shapedRecipes = new ArrayList();
    private ArrayList<ShapelessRecipe> shapelessRecipes = new ArrayList();
    private HashMap<Player, HashMap> playerHotbars = new HashMap();
    ArrayList<ItemStack> recipe = new ArrayList();
    ItemStack result;

    public void onEnable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        Logger logger = this.getLogger();
        logger.info(String.valueOf(pdfFile.getName()) + " has been enabled(V." + pdfFile.getVersion() + ")!");
        this.registerEvents();
        this.registerConfig();
        this.deserializeShapedRecipes();
        this.deserializeShapelessRecipes();
        logger.info("Recipes have been loaded!");
    }

    public void onDisable() {
        PluginDescriptionFile pdfFile = this.getDescription();
        Logger logger = this.getLogger();
        this.serializeShapedRecipes(this.shapedRecipes);
        this.serializeShapelessRecipes(this.shapelessRecipes);
        logger.info("Recipes have been saved!");
        logger.info(String.valueOf(pdfFile.getName()) + " has been disabled(V." + pdfFile.getVersion() + ")!");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (command.getName().equalsIgnoreCase("er")) {
            if (!(sender instanceof Player)) {
                return false;
            }
            Player player = (Player)sender;
            if (args.length == 0) {
                player.sendMessage("/er create: Create an item recipe.");
                return false;
            }
            if (args.length == 1) {
                if (args[0].equalsIgnoreCase("create")) {
                    Inventory inv = Bukkit.getServer().createInventory(null, InventoryType.WORKBENCH, "Recipe Maker");
                    HashMap<Integer, ItemStack> hotbar = new HashMap<Integer, ItemStack>();
                    ItemStack cont = new ItemStack(Material.WOOL, 1, 5);
                    ItemStack stop = new ItemStack(Material.WOOL, 1, 14);
                    ItemStack filler = new ItemStack(Material.STAINED_GLASS_PANE, 1, 15);
                    this.nameItem(filler, " ");
                    this.nameItem(cont, ChatColor.GREEN + ChatColor.ITALIC + "CONTINUE");
                    this.nameItem(stop, ChatColor.DARK_RED + ChatColor.ITALIC + "STOP");
                    int i = 0;
                    while (i < 9) {
                        hotbar.put(i, player.getInventory().getItem(i));
                        player.getInventory().clear(i);
                        ++i;
                    }
                    this.playerHotbars.put(player, hotbar);
                    player.getInventory().setItem(0, stop);
                    player.getInventory().setItem(8, cont);
                    i = 1;
                    while (i < 8) {
                        player.getInventory().setItem(i, filler);
                        ++i;
                    }
                    player.openInventory(inv);
                    player.sendMessage(ChatColor.GRAY + "Create your recipe in the crafting table! Then press " + ChatColor.GREEN + "CONTINUE.");
                    player.sendMessage(ChatColor.DARK_GRAY + "Press " + ChatColor.DARK_RED + "STOP" + ChatColor.DARK_GRAY + " to cancel and retrieve your hotbar.");
                    return false;
                }
                if (args[0].equalsIgnoreCase("continue")) {
                    this.recipe.clear();
                    int i = 1;
                    while (i < 10) {
                        this.recipe.add(player.getOpenInventory().getItem(i));
                        ++i;
                    }
                    player.closeInventory();
                    Inventory inv = Bukkit.getServer().createInventory(null, InventoryType.WORKBENCH, "Select Result");
                    ItemStack completeShaped = new ItemStack(Material.WOOL, 1, 13);
                    ItemStack completeShapeless = new ItemStack(Material.WOOL, 1, 5);
                    ItemStack stop = new ItemStack(Material.WOOL, 1, 14);
                    ItemStack filler = new ItemStack(Material.STAINED_GLASS_PANE, 1, 15);
                    this.nameItem(filler, " ");
                    this.nameItem(completeShaped, ChatColor.DARK_GREEN + ChatColor.ITALIC + "SHAPED");
                    this.nameItem(completeShapeless, ChatColor.GREEN + ChatColor.ITALIC + "SHAPELESS");
                    this.nameItem(stop, ChatColor.DARK_RED + ChatColor.ITALIC + "STOP");
                    player.getInventory().setItem(0, stop);
                    player.getInventory().setItem(7, completeShaped);
                    player.getInventory().setItem(8, completeShapeless);
                    int i2 = 1;
                    while (i2 < 7) {
                        player.getInventory().setItem(i2, filler);
                        ++i2;
                    }
                    player.openInventory(inv);
                    player.sendMessage(ChatColor.GRAY + "Select which material you are making! Then select either:");
                    player.sendMessage(ChatColor.DARK_GREEN + "  - SHAPED: Recipe will require the exact shape to craft the item.");
                    player.sendMessage(ChatColor.GREEN + "  - SHAPELESS: Recipe will craft the item using any shape with the correct materials.");
                    player.sendMessage("");
                    player.sendMessage(ChatColor.DARK_GRAY + "Press " + ChatColor.DARK_RED + "STOP" + ChatColor.DARK_GRAY + " to cancel and retrieve your hotbar.");
                    return false;
                }
                if (args[0].equalsIgnoreCase("select")) {
                    this.result = player.getInventory().getItem(4);
                    player.sendMessage(ChatColor.GRAY + "You have selected " + ChatColor.LIGHT_PURPLE + this.result.getType().name() + ChatColor.GRAY + " as the craftable item.");
                }
                if (args[0].equalsIgnoreCase("shaped")) {
                    ShapedRecipe r = new ShapedRecipe(this.result);
                    r.shape(new String[]{"012", "345", "678"});
                    int i = 0;
                    while (i < 9) {
                        if (this.recipe.get(i) != null) {
                            r.setIngredient(String.valueOf(i).charAt(0), this.recipe.get(i).getType(), (int)this.recipe.get(i).getData().getData());
                        }
                        ++i;
                    }
                    player.getServer().addRecipe((Recipe)r);
                    this.shapedRecipes.add(r);
                    player.sendMessage(ChatColor.DARK_GREEN + "You have successfully created a " + ChatColor.ITALIC + ChatColor.UNDERLINE + "SHAPED" + ChatColor.DARK_GREEN + " crafting recipe for " + ChatColor.LIGHT_PURPLE + this.result.getType().name() + ChatColor.DARK_GREEN + "!");
                    HashMap hotbar = this.playerHotbars.get(player);
                    int i3 = 0;
                    while (i3 < 9) {
                        player.getInventory().setItem(i3, (ItemStack)hotbar.get(i3));
                        ++i3;
                    }
                    this.serializeShapedRecipes(this.shapedRecipes);
                    return true;
                }
                if (args[0].equalsIgnoreCase("shapeless")) {
                    ShapelessRecipe r = new ShapelessRecipe(this.result);
                    for (ItemStack i : this.recipe) {
                        if (i == null) continue;
                        r.addIngredient(i.getType(), (int)i.getData().getData());
                    }
                    player.getServer().addRecipe((Recipe)r);
                    this.shapelessRecipes.add(r);
                    player.sendMessage(ChatColor.DARK_GREEN + "You have successfully created a " + ChatColor.ITALIC + ChatColor.UNDERLINE + "SHAPELESS" + ChatColor.DARK_GREEN + " crafting recipe for " + ChatColor.LIGHT_PURPLE + this.result.getType().name() + ChatColor.DARK_GREEN + "!");
                    HashMap hotbar = this.playerHotbars.get(player);
                    int i = 0;
                    while (i < 9) {
                        player.getInventory().setItem(i, (ItemStack)hotbar.get(i));
                        ++i;
                    }
                    this.serializeShapelessRecipes(this.shapelessRecipes);
                    return true;
                }
                if (args[0].equalsIgnoreCase("stop")) {
                    HashMap hotbar = this.playerHotbars.get(player);
                    int i = 0;
                    while (i < 9) {
                        player.getInventory().setItem(i, (ItemStack)hotbar.get(i));
                        ++i;
                    }
                    player.sendMessage(ChatColor.DARK_RED + "You have stopped creating a crafting recipe.");
                    return false;
                }
            }
        }
        return false;
    }

    public void registerEvents() {
        PluginManager pm = this.getServer().getPluginManager();
        pm.registerEvents((Listener)new InventoryClick(this), (Plugin)this);
    }

    private ItemStack nameItem(ItemStack item, String name) {
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(name);
        item.setItemMeta(meta);
        return item;
    }

    public void registerConfig() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
    }

    public void serializeShapedRecipes(Collection<ShapedRecipe> recipes) {
        for (ShapedRecipe recipe : recipes) {
            HashMap<Character, String> items = new HashMap<Character, String>();
            for (Character e : recipe.getIngredientMap().keySet()) {
                if (recipe.getIngredientMap().get(e) == null) {
                    items.put(e, null);
                    continue;
                }
                if (((ItemStack)recipe.getIngredientMap().get(e)).getData().getData() != 0) {
                    items.put(e, String.valueOf(((ItemStack)recipe.getIngredientMap().get(e)).getType().name()) + "#" + ((ItemStack)recipe.getIngredientMap().get(e)).getData().getData());
                    continue;
                }
                items.put(e, ((ItemStack)recipe.getIngredientMap().get(e)).getType().name());
            }
            if (recipe.getResult().getData().getData() != 0) {
                this.getConfig().createSection("shaped_recipes." + recipe.getResult().getAmount() + "#" + recipe.getResult().getType().name() + "#" + recipe.getResult().getData().getData(), items);
                continue;
            }
            this.getConfig().createSection("shaped_recipes." + recipe.getResult().getAmount() + "#" + recipe.getResult().getType().name(), items);
        }
        this.saveConfig();
    }

    public void serializeShapelessRecipes(Collection<ShapelessRecipe> recipes) {
        for (ShapelessRecipe recipe : recipes) {
            ArrayList<String> items = new ArrayList<String>();
            for (ItemStack e : recipe.getIngredientList()) {
                if (e.getData().getData() != 0) {
                    items.add(String.valueOf(e.getType().name()) + "#" + e.getData().getData());
                    continue;
                }
                items.add(e.getType().name());
            }
            if (recipe.getResult().getData().getData() != 0) {
                this.getConfig().set("shapeless_recipes." + recipe.getResult().getAmount() + "#" + recipe.getResult().getType().name() + "#" + recipe.getResult().getData().getData(), items);
                continue;
            }
            this.getConfig().set("shapeless_recipes." + recipe.getResult().getAmount() + "#" + recipe.getResult().getType().name(), items);
        }
        this.saveConfig();
    }

    public void deserializeShapedRecipes() {
        if (this.getConfig().contains("shaped_recipes")) {
            for (String e : this.getConfig().getConfigurationSection("shaped_recipes").getKeys(false)) {
                String[] s = e.split("#");
                Map items = this.getConfig().getConfigurationSection("shaped_recipes." + e).getValues(false);
                ShapedRecipe recipe = null;
                recipe = s.length == 3 ? new ShapedRecipe(new ItemStack(Material.getMaterial((String)s[1]), Integer.parseInt(s[0]), (short)Byte.parseByte(s[2]))) : new ShapedRecipe(new ItemStack(Material.getMaterial((String)s[1]), Integer.parseInt(s[0])));
                recipe.shape(new String[]{"012", "345", "678"});
                for (String x : items.keySet()) {
                    if (items.get(x).toString().contains("#")) {
                        String[] str = items.get(x).toString().split("#");
                        recipe.setIngredient(x.charAt(0), Material.getMaterial((String)str[0]), (int)Byte.parseByte(str[1]));
                        continue;
                    }
                    recipe.setIngredient(x.charAt(0), Material.getMaterial((String)((String)items.get(x))));
                }
                this.getServer().addRecipe((Recipe)recipe);
            }
        } else {
            return;
        }
    }

    public void deserializeShapelessRecipes() {
        if (this.getConfig().contains("shapeless_recipes")) {
            for (String e : this.getConfig().getConfigurationSection("shapeless_recipes").getKeys(false)) {
                String[] s = e.split("#");
                ShapelessRecipe recipe = null;
                recipe = s.length == 3 ? new ShapelessRecipe(new ItemStack(Material.getMaterial((String)s[1]), Integer.parseInt(s[0]), (short)Byte.parseByte(s[2]))) : new ShapelessRecipe(new ItemStack(Material.getMaterial((String)s[1]), Integer.parseInt(s[0])));
                for (String x : this.getConfig().getStringList("shapeless_recipes." + e)) {
                    if (x.contains("#")) {
                        String[] str = x.split("#");
                        recipe.addIngredient(Material.getMaterial((String)str[0]), (int)Byte.parseByte(str[1]));
                        continue;
                    }
                    recipe.addIngredient(Material.getMaterial((String)x));
                }
                this.getServer().addRecipe((Recipe)recipe);
            }
        } else {
            return;
        }
    }
}

