/*
 * Decompiled with CFR 0.152.
 */
package net.miblue;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import me.rmrm.mathapi.Exp;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Math
extends JavaPlugin
implements Listener {
    String prefix = ChatColor.DARK_PURPLE + "[MATH] " + ChatColor.LIGHT_PURPLE;
    ArrayList<String> autoPlayers = new ArrayList();
    HashMap<String, HashMap<String, Double>> userVariables = new HashMap();

    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getLogger().info("MATH has been enabled.");
    }

    public void onDisable() {
        this.getLogger().info("MATH has been disabled.");
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!sender.hasPermission("math.use")) {
            sender.sendMessage(this.prefix + "No permission.");
            return true;
        }
        try {
            if (label.equalsIgnoreCase("exp")) {
                this.expCommand(sender, args);
            } else if (label.equalsIgnoreCase("var")) {
                this.varCommand(sender, args);
            } else if (label.equalsIgnoreCase("math")) {
                this.mathCommand(sender, args);
            } else {
                sender.sendMessage(this.prefix + "Unknown Command!");
            }
        }
        catch (Exception e) {
            sender.sendMessage(this.prefix + "Error: " + e.getLocalizedMessage());
        }
        return true;
    }

    public void mathCommand(CommandSender sender, String[] args) {
        try {
            if (args.length == 0) {
                this.sendHelpHeader(sender);
                this.sendHelp(sender);
            } else {
                String[] v = (String[])args.clone();
                v[0] = null;
                if (args[0].equalsIgnoreCase("auto")) {
                    this.toggleAutomath(sender);
                } else if (args[0].equalsIgnoreCase("exp")) {
                    String cmd = "";
                    for (String s : args) {
                        cmd = cmd + " " + s;
                    }
                    cmd = cmd.replaceAll("exp", "");
                    cmd = cmd.trim();
                    this.expCommand(sender, cmd.split(" "));
                } else if (args[0].equalsIgnoreCase("var")) {
                    String cmd = "";
                    for (String s : args) {
                        cmd = cmd + " " + s;
                    }
                    cmd = cmd.replaceAll("var", "");
                    cmd = cmd.trim();
                    this.varCommand(sender, cmd.split(" "));
                } else {
                    sender.sendMessage(this.prefix + "Unknown Command!");
                }
            }
        }
        catch (Exception e) {
            sender.sendMessage(this.prefix + "Error: " + e.getLocalizedMessage());
        }
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onChat(AsyncPlayerChatEvent e) {
        try {
            if (this.autoPlayers.contains(e.getPlayer().getName())) {
                e.setCancelled(true);
                if (e.getMessage().equalsIgnoreCase("exit")) {
                    this.toggleAutomath((CommandSender)e.getPlayer());
                    return;
                }
                if (e.getMessage().startsWith("var ")) {
                    String[] parts = e.getMessage().replaceFirst("var ", "").split(" ");
                    this.varCommand((CommandSender)e.getPlayer(), parts);
                } else {
                    this.expCommand((CommandSender)e.getPlayer(), e.getMessage().split(" "));
                }
            }
        }
        catch (Exception ex) {
            e.getPlayer().sendMessage(this.prefix + "Error: " + ex.getLocalizedMessage());
        }
    }

    public void toggleAutomath(CommandSender sender) {
        if (this.autoPlayers.contains(sender.getName())) {
            this.autoPlayers.remove(sender.getName());
            sender.sendMessage(this.prefix + "Disabled automath.");
        } else {
            this.autoPlayers.add(sender.getName());
            sender.sendMessage(this.prefix + "Enabled automath. All chat messages (except those starting with var) will be interpreted as /exp inputs. Disable by saying 'exit'.");
        }
    }

    public void varCommand(CommandSender sender, String[] args) throws Exception {
        if (args.length == 0) {
            sender.sendMessage(this.prefix + "Define variables like /var def x=5");
            sender.sendMessage(this.prefix + "Clear all with /var clear");
            sender.sendMessage(this.prefix + "Remove individual variables with /var rem <variable>");
            sender.sendMessage(this.prefix + "View your variables with /var my");
        } else if (args[0].equalsIgnoreCase("clear")) {
            this.userVariables.remove(sender.getName());
            sender.sendMessage(this.prefix + "All variables cleared.");
        } else if (args[0].equalsIgnoreCase("my")) {
            HashMap<String, Double> va = this.userVariables.get(sender.getName());
            if (va == null) {
                va = new HashMap();
            }
            sender.sendMessage(this.prefix + "Your variables: (" + va.keySet().size() + ")");
            for (String s : va.keySet()) {
                sender.sendMessage(this.prefix + "    " + s + " = " + va.get(s));
            }
        } else if (args[0].equalsIgnoreCase("rem")) {
            if (args.length == 1) {
                sender.sendMessage(this.prefix + "Usage: /var rem <variable>");
                return;
            }
            HashMap<String, Double> variables = this.userVariables.get(sender.getName());
            if (variables == null) {
                variables = new HashMap();
            }
            if (!variables.containsKey(args[1])) {
                sender.sendMessage(this.prefix + "No such variable defined.");
                return;
            }
            variables.remove(args[1]);
            sender.sendMessage(this.prefix + "Removed variable: " + args[1]);
        } else if (args[0].equalsIgnoreCase("def")) {
            if (args.length < 2) {
                sender.sendMessage(this.prefix + "Usage: /var def <variables...>");
                return;
            }
            HashMap<String, Double> variables = this.userVariables.get(sender.getName());
            if (variables == null) {
                variables = new HashMap();
            }
            String c = "";
            for (String a : args) {
                if (a.equalsIgnoreCase("def")) continue;
                c = c + " " + a;
            }
            c = c.trim();
            c = c.replaceAll(" ", "");
            String[] parts = c.split(",");
            ArrayList<String> vars = new ArrayList<String>();
            for (String s : parts) {
                vars.add(s);
            }
            for (String s : vars) {
                String[] p = s.split("=");
                if (p[0].equalsIgnoreCase("")) {
                    throw new Exception("Empty variable name!");
                }
                if (p.length != 2) {
                    throw new Exception("Incomplete variable declaration: " + s);
                }
                boolean global = p[0].startsWith("*");
                if (global && this.getGlobalVariable(p[0]) != null) {
                    sender.sendMessage(this.prefix + "Unable to store server variable because that variable is already defined.");
                    return;
                }
                variables.put(p[0], Double.valueOf(p[1]));
            }
            this.userVariables.put(sender.getName(), variables);
            sender.sendMessage(this.prefix + "Successfully defined global variable(s):");
            for (String s : variables.keySet()) {
                sender.sendMessage(this.prefix + "    " + s + " = " + variables.get(s));
            }
        } else {
            sender.sendMessage(this.prefix + "Unknown subcommand.");
        }
    }

    public void expCommand(CommandSender sender, String[] args) throws Exception {
        if (sender.hasPermission("math.use")) {
            if (args.length == 0) {
                this.sendHelpHeader(sender);
                this.sendHelp(sender);
            } else {
                HashMap<String, Double> variables;
                if (args[0].equalsIgnoreCase("functions")) {
                    this.sendFunctions(sender);
                    return;
                }
                long startTime = System.currentTimeMillis();
                boolean store = false;
                String var = "";
                if (args.length > 1 && args[args.length - 1].startsWith("->")) {
                    store = true;
                    String s = args[args.length - 1].trim();
                    var = s = s.replaceAll("->", "");
                    store = true;
                }
                if ((variables = this.userVariables.get(sender.getName())) == null) {
                    variables = new HashMap();
                }
                String c = "";
                for (String a : args) {
                    if (store) {
                        if (a.equals(args[args.length - 1])) continue;
                        c = c + " " + a;
                        continue;
                    }
                    c = c + " " + a;
                }
                c = c.trim();
                c = c.replaceAll(" ", "");
                String[] parts = c.split(",");
                String equation = parts[0];
                ArrayList<String> vars = new ArrayList<String>();
                for (String s : parts) {
                    vars.add(s);
                }
                vars.remove(0);
                for (String s : vars) {
                    String[] p = s.split("=");
                    if (p.length != 2) {
                        throw new Exception("Incomplete variable declaration: " + s);
                    }
                    try {
                        variables.put(p[0], Double.valueOf(p[1]));
                    }
                    catch (Exception e) {
                        Exp ex = new Exp(p[1], new HashMap<String, Double>());
                    }
                }
                variables.putAll(this.getGlobalVariables());
                Exp exp = new Exp(equation, variables);
                double value = exp.calculate();
                sender.sendMessage(this.prefix + "Successfully evaluated expression in " + (System.currentTimeMillis() - startTime) / 1000L + " seconds.");
                sender.sendMessage(this.prefix + equation + " = " + ChatColor.DARK_PURPLE + ChatColor.UNDERLINE + value);
                if (store) {
                    boolean global;
                    HashMap<String, Double> v = this.userVariables.get(sender.getName());
                    if (v == null) {
                        v = new HashMap();
                    }
                    if ((global = Character.isUpperCase(var.charAt(0))) && this.getGlobalVariable(var) != null) {
                        sender.sendMessage(this.prefix + "Unable to store server variable (capitalized) because that variable is already defined.");
                        return;
                    }
                    v.put(var, value);
                    sender.sendMessage(this.prefix + "Stored variable " + ChatColor.DARK_PURPLE + ChatColor.UNDERLINE + var + ChatColor.LIGHT_PURPLE + " as " + ChatColor.DARK_PURPLE + ChatColor.UNDERLINE + value);
                    if (global) {
                        sender.sendMessage(this.prefix + "This is a server variable because it is capitalized. Others will be able to access it, but not modify it.");
                    }
                    this.userVariables.put(sender.getName(), v);
                }
            }
        } else {
            sender.sendMessage(this.prefix + ChatColor.RED + "You don't have permission to use MATH.");
        }
    }

    public Double getGlobalVariable(String name) {
        Double d = null;
        for (HashMap<String, Double> map : this.userVariables.values()) {
            for (String s : map.keySet()) {
                if (!s.equals(name) || !Character.isUpperCase(name.charAt(0))) continue;
                d = new Double(map.get(s));
            }
        }
        return d;
    }

    public Map<String, Double> getGlobalVariables() {
        HashMap<String, Double> vars = new HashMap<String, Double>();
        for (HashMap<String, Double> map : this.userVariables.values()) {
            for (String s : map.keySet()) {
                if (!Character.isUpperCase(s.charAt(0))) continue;
                vars.put(s, map.get(s));
            }
        }
        return vars;
    }

    public void sendHelpHeader(CommandSender sender) {
        sender.sendMessage(this.prefix + "Help " + ChatColor.STRIKETHROUGH + "---------------------------------------");
    }

    public void sendHelp(CommandSender sender) {
        sender.sendMessage(this.prefix + "Command usages:");
        sender.sendMessage(this.prefix + "    /math var <def/my/clear>|exp <expression> [variables...]|auto // gateway command");
        sender.sendMessage(this.prefix + "    /exp <expression> [variables...] [->variable]// evaluate expressions");
        sender.sendMessage(this.prefix + "      /exp 5+5 // evaluate 5+5");
        sender.sendMessage(this.prefix + "      /exp x/y,x=5,y=6 // evaluate x/y where x=5, y=6");
        sender.sendMessage(this.prefix + "      /exp 5+3 ->x // store global variable x as 5+3");
        sender.sendMessage(this.prefix + "    /var def|my|clear // define global variables");
        sender.sendMessage(this.prefix + "Example simple expressions:");
        sender.sendMessage(this.prefix + "    5 + 3");
        sender.sendMessage(this.prefix + "    3 * sin(5) - 2 / (1 - 2)");
        sender.sendMessage(this.prefix + "Example variable expressions:");
        sender.sendMessage(this.prefix + "    x+5,x=1");
        sender.sendMessage(this.prefix + "    5 * sin(x) - (3 - z),x=5,z=4");
        sender.sendMessage(this.prefix + "    (declare variables in the form of <variable>=<value>,...)");
        sender.sendMessage(this.prefix + "Built-in functions:");
        sender.sendMessage(this.prefix + "    view /exp functions");
        sender.sendMessage(this.prefix + "Want even more? Read library documentation @ http://projects.congrace.de/exp4j/");
    }

    public void sendFunctions(CommandSender sender) {
        String[] p;
        String f = "    - abs: absolute value\n    - acos: arc cosine\n    - asin: arc sine\n    - atan: arc tangent\n    - cbrt: cubic root\n    - ceil: nearest upper integer\n    - cos: cosine\n    - cosh: hyperbolic cosine\n    - exp: euler's number raised to the power (e^x)\n    - floor: nearest lower integer\n    - log: logarithmus naturalis (base e)\n    - log10: logarithm (base 10)\n    - log2: logarithm (base 2)\n    - sin: sine\n    - sinh: hyperbolic sine\n    - sqrt: square root\n    - tan: tangent\n    - tanh: hyperbolic tangent";
        for (String s : p = f.split("\n")) {
            sender.sendMessage(this.prefix + s);
        }
    }
}

