/*******************************************************************************
 * Copyright 2014 stuntguy3000 (Luke Anderson) and coasterman10.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 * 
 * Edited by botifier.
 ******************************************************************************/
package com.fg.enhance.listeners;
import java.util.Arrays;
import java.util.Iterator;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.event.Event.Result;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

import com.fg.enhance.Enhance;
import com.fg.enhance.kits.Kit;
import com.fg.enhance.meta.Meta;


public class SoulboundListener implements Listener {
    private static final String soulboundTag = ChatColor.GOLD + "Soulbound";
    Enhance e;
    public SoulboundListener ( Enhance l ){
    	e = l;
    }
    @EventHandler
    public void onSoulboundDrop(PlayerDropItemEvent e) {
        if (isSoulbound(e.getItemDrop().getItemStack())) {
            Player p = e.getPlayer();
            p.playSound(p.getLocation(), Sound.BLAZE_HIT, 1.0F, 0.5F);
            e.getItemDrop().remove();
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent e) {
        Iterator<ItemStack> it = e.getDrops().iterator();
        while (it.hasNext()) {
            if (isSoulbound(it.next()))
                it.remove();
        }
    }
    public void onDrag(InventoryDragEvent e) {
    	if (isSoulbound(e.getCursor())) {
    			e.setResult(Result.DENY);
				e.setCancelled(true);
				return;
    	}
    }
    @EventHandler
	public void onInventoryClick(InventoryClickEvent e) {
		if (e.getInventory().getType() == null)
			return;
		
		Inventory inv = e.getInventory();
		Player player = (Player) e.getWhoClicked();
		if (e.getInventory().getType() == InventoryType.CREATIVE || e.getInventory().getType() == InventoryType.CRAFTING || e.getInventory().getType() == InventoryType.PLAYER) {
			
		} else {
			if (e.getClick() == ClickType.NUMBER_KEY) {
				e.setCancelled(true);
				return;
			}
		}
		if (isSoulbound(e.getCurrentItem())) {
			if (e.getInventory().getType() == InventoryType.CREATIVE || e.getInventory().getType() == InventoryType.CRAFTING || e.getInventory().getType() == InventoryType.PLAYER) {
				
			} else {
				e.setCancelled(true);
			}
		}
		
		if (inv.getTitle().startsWith("Current kit: ")) {
			if (e.getCurrentItem().getType() == Material.AIR)
				return;
			for (Kit type : Kit.values()) {
				if (e.getCurrentItem().getItemMeta().getDisplayName().equalsIgnoreCase(type.getName())) {
					String name = e.getCurrentItem().getItemMeta().getDisplayName();
					Meta meta = Meta.getMeta(player.getUniqueId());
					meta.setKit(type);
					if (type != Kit.NONE) {
						player.sendMessage(ChatColor.DARK_AQUA + "Selected " + ChatColor.stripColor(name));
					} else {
						player.sendMessage(ChatColor.DARK_AQUA + "Kit Removed");
					}
					if (type == Kit.AGILE) {
						meta.setCoolDown(player.getUniqueId(), 7);
					}
					player.setHealth(0.0);
					e.setResult(Result.DENY);
				}
			}
	}
    }
    
    public static boolean isSoulbound(ItemStack item) {
        ItemMeta meta = item.getItemMeta();
        if (item.hasItemMeta())
            if (meta.hasLore())
                if (meta.getLore().contains(soulboundTag))
                    return true;
        return false;
    }
    
    public static void soulbind(ItemStack stack) {
        ItemMeta meta = stack.getItemMeta();
        if (!meta.hasLore())
            meta.setLore(Arrays.asList(soulboundTag));
        else
            meta.getLore().add(soulboundTag);
        stack.setItemMeta(meta);
    }
}
