package com.fg.enhance.listeners;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Effect;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryType;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

import com.fg.enhance.Enhance;
import com.fg.enhance.kits.Kit;
import com.fg.enhance.meta.Meta;
import com.sk89q.worldguard.bukkit.WGBukkit;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.flags.DefaultFlag;
import com.sk89q.worldguard.protection.flags.StateFlag.State;

public class PlayerListener implements Listener {
	private Enhance plugin;
	private ApplicableRegionSet set;
	private ApplicableRegionSet set2;
	ItemStack i = new ItemStack(Material.BLAZE_ROD);

	public PlayerListener(Enhance e) {
		plugin = e;
	}
	@SuppressWarnings("deprecation")
	@EventHandler
	public void onPlayerRespawn(final PlayerRespawnEvent e) {
		Player p = e.getPlayer();
		Meta m = Meta.getMeta(p.getUniqueId());
		p.setWalkSpeed(0.2F);
		p.setMaxHealth(20.0);
		if (m.getKit().equals(Kit.HEAVY)) {
			plugin.getServer().getScheduler().scheduleAsyncDelayedTask(plugin, new Runnable() {
		        public void run() {             
		        	e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SLOW, Integer.MAX_VALUE, 1));
					e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.DAMAGE_RESISTANCE, Integer.MAX_VALUE, 0));
					//e.getPlayer().setMaxHealth(40);
		        }
		    }, 20);
		} else {
			p.setMaxHealth(20.0);
		}
		if (m.getKit().equals(Kit.AGILE)) {
			plugin.getServer().getScheduler().scheduleAsyncDelayedTask(plugin, new Runnable() {
		        public void run() {             
		        	e.getPlayer().addPotionEffect(new PotionEffect(PotionEffectType.SPEED, Integer.MAX_VALUE, 0));
					//e.getPlayer().setMaxHealth(40);
		        }
		    }, 20);
		}
		/*if (m.getKit() == Kit.HIDDEN) {
			m.setCoolDown(p.getUniqueId(), 40);
		}
		if (m.getKit() == Kit.ENRAGED) {
			m.setCoolDown(p.getUniqueId(), 40);
		}
		if (m.getKit() == Kit.TRICKSTER) {
			m.setCoolDown(p.getUniqueId(), 40);
		}*/
		m.getKit().give(p);
	}
	@EventHandler
	public void onFly(PlayerToggleFlightEvent event)
	{
		Player player = event.getPlayer();
		Meta m = Meta.getMeta(player.getUniqueId());
		if (m.getKit() == Kit.AGILE) {
					if(player.getGameMode() != GameMode.CREATIVE)
					{
						event.setCancelled(true);
						player.setAllowFlight(false);
						player.setFlying(false);
						player.setVelocity(player.getLocation().getDirection().multiply(0.75).setY(0.75));
						player.getWorld().playSound(player.getLocation(), Sound.MAGMACUBE_JUMP, 1.0F, 2.0F);
						m.setCoolDown(player.getUniqueId(), 7);
					}
		}
	}
	@EventHandler
	public void onMove(PlayerMoveEvent event) {
		Player player = event.getPlayer();
		Meta m = Meta.getMeta(player.getUniqueId());
		if (m.getKit() == Kit.AGILE) {
			if(player.getGameMode() != GameMode.CREATIVE)
			{
				if(player.getLocation().getBlock().getRelative(BlockFace.DOWN).getType() != Material.AIR)
				{
					if (m.getCoolDown(player.getUniqueId()) <= 0)
						player.setAllowFlight(true);
				}
			}
		}
		else {
			if(player.getGameMode() != GameMode.CREATIVE) {
				player.setAllowFlight(false);
			}
		}
	}
}
