package com.fg.enhance.kits;

import java.util.ArrayList;
import java.util.List;
import java.util.jar.Attributes;

import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.craftbukkit.v1_7_R2.inventory.CraftItemStack;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;

import com.fg.enhance.listeners.SoulboundListener;
import com.fg.enhance.meta.Meta;

public enum Kit {
	NONE (Material.WOOL),
	PYRO(Material.FIREBALL) 
	{
		{
			lore.add("25% chance of igniting the target.");
			lore.add("25% chance of fire arrrow.");
			addItem(sword);
			addItem(bow);
			addItem(pickaxe);
			addItem(axe);
			addItem(new ItemStack(Material.ARROW, 16));
		}
	},
	SUPPLIER(Material.WOOD_PICKAXE) 
	{
		{
			lore.add("Supply your mates");
			lore.add("or yourself with loads of supplies!");
			addItem(sword);
			addItem(pickaxe);
			addItem(axe);
		}
	},
	HEAVY(Material.BREAD) {
		{
			lore.add("Sandwiches not incuded");
			addItem(sword);
			addItem(pickaxe);
			addItem(axe);
		}
	},
	LEECH(Material.REDSTONE_TORCH_ON) {
		{
			lore.add("Leechy leech, leechy leech,");
			lore.add("does whatever a leechy leech does.");

			addItem(sword);
			addItem(pickaxe);
			addItem(axe);
		}
	},
	AGILE (Material.FEATHER) {
		{
			lore.add("Double jumping capable.");
			addItem(sword);
			addItem(pickaxe);
			addItem(axe);
			addItem(bow);
			addItem(new ItemStack(Material.ARROW, 16));
		}
	}, 
	ARCHER (Material.BOW) {
		{
			lore.add("+1 arrow Damage");
			addItem(bow);
			addItem(sword);
			addItem(pickaxe);
			addItem(axe);
			addItem(new ItemStack(Material.ARROW, 16));
		}
	},
	WARRIOR (Material.WOOD_SWORD) {
		{
			lore.add("+1 Melee Damage");
			addItem(sword);
			addItem(pickaxe);
			addItem(axe);
		}
	};
	
	ItemStack sword = new ItemStack(Material.WOOD_SWORD);
	ItemStack axe = new ItemStack(Material.WOOD_AXE);
	ItemStack pickaxe = new ItemStack(Material.WOOD_PICKAXE);
	ItemStack bow = new ItemStack(Material.BOW);
	static {
		for (Kit kit : values())
			kit.init();
	}
	private ItemStack icon;
	public List<String> lore = new ArrayList<String>();
	public List<ItemStack> spawnItems = new ArrayList<ItemStack>();
	ItemStack[] spawnArmor = new ItemStack[] {
			new ItemStack(Material.LEATHER_BOOTS),
			new ItemStack(Material.LEATHER_LEGGINGS),
			new ItemStack(Material.LEATHER_CHESTPLATE),
			new ItemStack(Material.LEATHER_HELMET) };
	
	Kit(Material m) {
		icon = new ItemStack(m);
		ItemMeta meta = icon.getItemMeta();
		meta.setDisplayName(getName());
		icon.setItemMeta(meta);
	}
	public void setArmor(ItemStack[] armor) {
		spawnArmor = armor;
	}
	
	public void addItem(ItemStack item) {
		spawnItems.add(item);
	}
	
	public String getName() {
		return name().substring(0, 1) + name().substring(1).toLowerCase();
	}
	
	private void init() {
		for (int i = 0; i < lore.size(); i++) {
			String s = lore.get(i);
			s = ChatColor.AQUA + s;
			lore.set(i, s);
		}
		ItemMeta meta = icon.getItemMeta();
		meta.setLore(lore);
		icon.setItemMeta(meta);
	}
	
	public static Kit getKit(String name) {
		for (Kit type : values()) {
            if (type.name().equalsIgnoreCase(name))
                return type;
        }
		return null;
	}
	
	public void give(Player recipient) {
		PlayerInventory inv = recipient.getInventory();
		inv.clear();
		for (ItemStack item : spawnItems) {
			ItemStack toGive = item.clone();
			SoulboundListener.soulbind(toGive);
			inv.addItem(toGive);
		}
		if (this != NONE) {
			inv.setArmorContents(spawnArmor);
			for (ItemStack armor : inv.getArmorContents())
				SoulboundListener.soulbind(armor);
		}
	}

	public ItemStack getIcon() {
		return icon;
	}
}
