package com.fg.enhance.cmd;

import java.io.File;

import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

import com.fg.enhance.Enhance;
import com.fg.enhance.meta.Meta;

public class EnhanceCommand implements CommandExecutor {
	private Enhance plugin;
	
	public EnhanceCommand(Enhance enhance) {
		plugin = enhance;
	}
	
	public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
		String prefix = ChatColor.RED + "[ENHANCE] " + ChatColor.GREEN;
		
		if (args.length == 0) {
			sender.sendMessage(ChatColor.RED + "<<<ENHANCE by botifier>>>");
			sender.sendMessage(prefix + "/e" + " - " + "Shows the Enhance Gamemode's help.");
			sender.sendMessage(prefix + "/e admin" + " - " + "Shows the Enhance Gamemode's admin help.");
			sender.sendMessage(prefix + "/kit" + " - " + "Shows you the kit gui.");
		} else if (args.length == 1) {
			if (args[0].equalsIgnoreCase("admin")) {
				if (sender.hasPermission("enhance.admin")) {
					sender.sendMessage("'<' and '>' indicate optional parts in between them.");
					sender.sendMessage(prefix + "/heal <playername>");
				}
			}
		} else if (args.length == 2) {
			if (args[0].equalsIgnoreCase("admin")) {
				if (args[1].equalsIgnoreCase("resetmeta")) {
					if (sender.hasPermission("enhance.admin")) {
						plugin.reset();
						Meta.metaTable.clear();
						plugin.saveDefaultConfig();
						sender.sendMessage("Meta Cleared!");
					}
				}
			}
		}
		return false;
	}
}
