package com.fg.enhance;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;

import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;

import com.fg.enhance.cmd.EnhanceCommand;
import com.fg.enhance.cmd.HealCommand;
import com.fg.enhance.cmd.KitCommand;
import com.fg.enhance.kits.Kit;
import com.fg.enhance.listeners.KitAbilityListener;
import com.fg.enhance.listeners.PlayerListener;
import com.fg.enhance.listeners.SoulboundListener;
import com.fg.enhance.meta.Meta;
import com.sk89q.worldguard.bukkit.WorldGuardPlugin;

public class Enhance extends JavaPlugin {
	KitAbilityListener l = new KitAbilityListener(this);
	@Override
	public void onEnable() {
		PluginManager pm = getServer().getPluginManager();
		loadKit();
		//loadParty();
		getCommand("kit").setExecutor(new KitCommand());
		getCommand("enhance").setExecutor(new EnhanceCommand(this));
		getCommand("heal").setExecutor(new HealCommand());
		//getCommand("party").setExecutor(new PartyCommand());
		pm.registerEvents(new SoulboundListener(this), this);
		pm.registerEvents(new PlayerListener(this), this);
		pm.registerEvents(l, this);
		for (Player p : Bukkit.getOnlinePlayers()) {
			Meta m = Meta.getMeta(p.getUniqueId());
			if (m.getKit() == Kit.AGILE) {
				m.setCoolDown(p.getUniqueId(), 7);
			}
		}
		BukkitTask Cooldown = new Cooldown().runTaskTimer(this, 20, 20);
	}
	
	@Override
	public void onDisable() {
		File configFile = new File(this.getDataFolder(), "config.yml");
		configFile.delete();
		saveKit();
		//saveParty();
		this.saveConfig();
	}
	public void reset() {
		for (Player p : Bukkit.getOnlinePlayers()) {
			Meta m = Meta.getMeta(p.getUniqueId());
			m.reset();
		}
		for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
			Meta m = Meta.getMeta(p.getUniqueId());
			m.reset();
		}
	}
	public static void showClassSelector(Player player, String title) {
		int size = ((Kit.values().length + 8) / 9) * 9;
		Inventory inv = Bukkit.createInventory(null, size, title);
		for (Kit kit : Kit.values())
			inv.addItem(kit.getIcon());
		player.openInventory(inv);
	}
	
	public WorldGuardPlugin getWorldGuard() {
	    Plugin plugin = getServer().getPluginManager().getPlugin("WorldGuard");
	 
	    // WorldGuard may not be loaded
	    if (plugin == null || !(plugin instanceof WorldGuardPlugin)) {
	        return null; // Maybe you want throw an exception instead
	    }
	 
	    return (WorldGuardPlugin) plugin;
	}
	
	public void loadKit() {
		if (Bukkit.getOnlinePlayers() != null) {
			for (Player p : Bukkit.getOnlinePlayers()) {
				UUID u = null;
				if (p.getPlayer() != null) {
					u = p.getUniqueId();
				}
				if (u != null) {
					com.fg.enhance.meta.Meta meta = com.fg.enhance.meta.Meta.getMeta(u);
					for (Kit k : Kit.values()) {
						if (this.getConfig().contains("players." + u.toString() + ".kit")) {
							if (this.getConfig().get("players." + u.toString() + ".kit").equals(k.getName())) {
								meta.setKit(Kit.getKit(this.getConfig().getString("players." + u.toString() + ".kit")));
							}
						}
					}
			}
		}
		}
		if (Bukkit.getOfflinePlayers() != null) {
			for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
				
				UUID u = null;
				if (p.getPlayer() != null) {
					u = p.getUniqueId();
				}
				if (u != null) {
					com.fg.enhance.meta.Meta meta = com.fg.enhance.meta.Meta.getMeta(u);
					for (Kit k : Kit.values()) {
						if (this.getConfig().contains("players." + u.toString() + ".kit")) {
							if (this.getConfig().get("players." + u.toString() + ".kit").equals(k.getName())) {
								meta.setKit(Kit.getKit(this.getConfig().getString("players." + u.toString() + ".kit")));
							}
						}
					}
				}
			}
		}
	}
	
	public void saveKit() {
		if (Bukkit.getOnlinePlayers() != null) {
			for (Player p : Bukkit.getOnlinePlayers()) {
				UUID u = null;
				if (p.getPlayer() != null) {
					u = p.getUniqueId();
				}
				if (u != null) {
					com.fg.enhance.meta.Meta meta = com.fg.enhance.meta.Meta.getMeta(u);
					File configFile = new File(this.getDataFolder(), "config.yml");
					if (!configFile.exists()) {
						try {
							getConfig().save(configFile);
						} catch (IOException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}
					try {
						getConfig().load("config.yml");
					} catch (FileNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (InvalidConfigurationException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					String ka = "players." + p.getUniqueId()+ ".kit";
					if (!this.getConfig().contains(ka)) {
						this.getConfig().createSection(ka);
					}
					this.getConfig().set(ka, meta.getKit().getName());
					try {
						this.getConfig().save("config.yml");
						this.saveConfig();
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}
			}
		} 
		if (Bukkit.getOfflinePlayers() != null) {
			for (OfflinePlayer p : Bukkit.getOfflinePlayers()) {
				UUID u = null;
				if (p.getPlayer() != null) {
					u = p.getUniqueId();
				}
				if (u != null) {
					com.fg.enhance.meta.Meta meta = com.fg.enhance.meta.Meta.getMeta(u);
					File configFile = new File(this.getDataFolder(), "config.yml");
					if (!configFile.exists()) {
						try {
							getConfig().save(configFile);
						} catch (IOException e1) {
							// TODO Auto-generated catch block
							e1.printStackTrace();
						}
					}
					try {
						getConfig().load("config.yml");
					} catch (FileNotFoundException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (IOException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					} catch (InvalidConfigurationException e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
					}
					String ka = "players." + p.getUniqueId()+ ".kit";
					if (!this.getConfig().contains(ka)) {
						this.getConfig().createSection(ka);
					}
					this.getConfig().set(ka, meta.getKit().getName());
					try {
						this.getConfig().save("config.yml");
						this.saveConfig();
					} catch (IOException e1) {
						// TODO Auto-generated catch block
						e1.printStackTrace();
					}
				}
			}
		}
	}
}
