/*
 * Decompiled with CFR 0.152.
 */
package de.mauricius17.rocket.warp;

import de.mauricius17.rocket.enums.CertainWorlds;
import de.mauricius17.rocket.rocket.Rocket;
import de.mauricius17.rocket.system.Rocket;
import de.mauricius17.rocket.utils.Utils;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.WorldCreator;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class Warp {
    Location location;
    String name;

    public Warp(String name) {
        this.location = null;
        this.name = name;
    }

    public Warp(String name, Location location) {
        this.location = location;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Location getLocation() {
        return this.location;
    }

    public Location getLocationByConfig() {
        String world = Utils.getWarpsConfiguration().getString("warp." + this.name + ".world");
        if (world == null) {
            return null;
        }
        double x = Utils.getWarpsConfiguration().getDouble("warp." + this.name + ".x");
        double y = Utils.getWarpsConfiguration().getDouble("warp." + this.name + ".y");
        double z = Utils.getWarpsConfiguration().getDouble("warp." + this.name + ".z");
        double yaw = Utils.getWarpsConfiguration().getDouble("warp." + this.name + ".yaw");
        double pitch = Utils.getWarpsConfiguration().getDouble("warp." + this.name + ".pitch");
        Bukkit.createWorld((WorldCreator)new WorldCreator(world));
        Location loc = new Location(Bukkit.getWorld((String)world), x, y, z);
        loc.setYaw((float)yaw);
        loc.setPitch((float)pitch);
        return loc;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public void teleport(final Player p) {
        if (Utils.getCertainWorlds().equals((Object)CertainWorlds.ON)) {
            String[] worlds;
            String[] stringArray = worlds = Utils.getWorlds().split(",");
            int n = worlds.length;
            int n2 = 0;
            while (n2 < n) {
                String w = stringArray[n2];
                if (w.equals(p.getWorld().getName())) {
                    if (!Utils.getRocket().containsKey(p.getUniqueId())) {
                        if (!Utils.getParachute().containsKey(p.getUniqueId())) {
                            de.mauricius17.rocket.rocket.Rocket rocket = new de.mauricius17.rocket.rocket.Rocket((Plugin)Rocket.getInstance(), p);
                            rocket.build(p.getLocation());
                            rocket.addPlayer();
                            rocket.start(Utils.getHeightOfTrip(), new Rocket.RocketInterface(){

                                @Override
                                public void onRocketDestroy() {
                                    Block b = p.getLocation().getBlock();
                                    int i = 0;
                                    while (i < 3) {
                                        if (b.getRelative(BlockFace.DOWN).getTypeId() == 0) {
                                            b = b.getRelative(BlockFace.DOWN);
                                            if (i == 2) {
                                                p.teleport(Warp.this.location);
                                                p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20, 1, false));
                                                p.playSound(p.getLocation(), Sound.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                                                p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Utils.getPrefix()) + Utils.getMessages().getString("command.warp.teleport.successful"))).replace("[WARP]", Warp.this.name));
                                            }
                                        } else {
                                            i = 3;
                                        }
                                        ++i;
                                    }
                                }
                            });
                            Utils.getRocket().put(p.getUniqueId(), rocket);
                            p.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("rocket.started")));
                        } else {
                            p.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("rocket.start_while_parachute_is_open")));
                        }
                    } else {
                        p.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("rocket.already_started")));
                    }
                    return;
                }
                ++n2;
            }
        } else if (!Utils.getRocket().containsKey(p.getUniqueId())) {
            if (!Utils.getParachute().containsKey(p.getUniqueId())) {
                de.mauricius17.rocket.rocket.Rocket rocket = new de.mauricius17.rocket.rocket.Rocket((Plugin)Rocket.getInstance(), p);
                rocket.build(p.getLocation());
                rocket.addPlayer();
                rocket.start(Utils.getHeightOfTrip(), new Rocket.RocketInterface(){

                    @Override
                    public void onRocketDestroy() {
                        Block b = p.getLocation().getBlock();
                        int i = 0;
                        while (i < 3) {
                            if (b.getRelative(BlockFace.DOWN).getTypeId() == 0) {
                                b = b.getRelative(BlockFace.DOWN);
                                if (i == 2) {
                                    p.teleport(Warp.this.location);
                                    p.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 20, 1, false));
                                    p.playSound(p.getLocation(), Sound.ENDERMAN_TELEPORT, 1.0f, 1.0f);
                                    p.sendMessage(ChatColor.translateAlternateColorCodes((char)'&', (String)(String.valueOf(Utils.getPrefix()) + Utils.getMessages().getString("command.warp.teleport.successful"))).replace("[WARP]", Warp.this.name));
                                }
                            } else {
                                i = 3;
                            }
                            ++i;
                        }
                    }
                });
                Utils.getRocket().put(p.getUniqueId(), rocket);
                p.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("rocket.started")));
            } else {
                p.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("rocket.start_while_parachute_is_open")));
            }
        } else {
            p.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("rocket.already_started")));
        }
    }

    public boolean remove() {
        String[] warps = Utils.getWarpsConfiguration().getString("warps").split(";");
        String newWarps = "";
        String[] stringArray = warps;
        int n = warps.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            if (!w.equalsIgnoreCase(this.name)) {
                newWarps = String.valueOf(newWarps) + w + ";";
            }
            ++n2;
        }
        if (newWarps.equals(";")) {
            newWarps = "";
        }
        Utils.getWarpsConfiguration().set("warps", (Object)newWarps);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".world", null);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".x", null);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".y", null);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".z", null);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".yaw", null);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".pitch", null);
        try {
            Utils.getWarpsConfiguration().save(Utils.getWarpFile());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean set() {
        String w;
        String world = this.location.getWorld().getName();
        double x = this.location.getX();
        double y = this.location.getY();
        double z = this.location.getZ();
        double yaw = this.location.getYaw();
        double pitch = this.location.getPitch();
        String[] warps = Utils.getWarpsConfiguration().getString("warps").split(";");
        String newWarps = "";
        String[] stringArray = warps;
        int n = warps.length;
        int n2 = 0;
        while (n2 < n) {
            w = stringArray[n2];
            if (w.equals(this.name)) {
                return false;
            }
            ++n2;
        }
        stringArray = warps;
        n = warps.length;
        n2 = 0;
        while (n2 < n) {
            w = stringArray[n2];
            newWarps = String.valueOf(newWarps) + w + ";";
            ++n2;
        }
        newWarps = String.valueOf(newWarps) + this.name + ";";
        Utils.getWarpsConfiguration().set("warps", (Object)newWarps);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".world", (Object)world);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".x", (Object)x);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".y", (Object)y);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".z", (Object)z);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".yaw", (Object)yaw);
        Utils.getWarpsConfiguration().set("warp." + this.name + ".pitch", (Object)pitch);
        try {
            Utils.getWarpsConfiguration().save(Utils.getWarpFile());
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

