/*
 * Decompiled with CFR 0.152.
 */
package de.mauricius17.rocket.system;

import com.google.common.reflect.ClassPath;
import de.mauricius17.rocket.commands.ParachuteCommand;
import de.mauricius17.rocket.commands.RocketCommand;
import de.mauricius17.rocket.enums.CertainWorlds;
import de.mauricius17.rocket.utils.Items;
import de.mauricius17.rocket.utils.Recipes;
import de.mauricius17.rocket.utils.Utils;
import de.mauricius17.rocket.warp.Warp;
import java.io.IOException;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;

public class Rocket
extends JavaPlugin {
    private static Rocket instance;

    public void onEnable() {
        Enum recipes;
        instance = this;
        this.loadConfig();
        this.loadMessages();
        this.loadWarpsConfig();
        this.loadWarps();
        this.registerEvents();
        this.registerCommands();
        Utils.setPrefix(ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("prefix")));
        Utils.setNoPermission(ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("noPermission")));
        Utils.setConsole(ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("console")));
        Utils.setHeightOfTrip(Utils.getConfig().getInt("heigh_of_rockettrip"));
        if (Utils.getConfig().getBoolean("certain_worlds")) {
            Utils.setCertainWorlds(CertainWorlds.ON);
        } else {
            Utils.setCertainWorlds(CertainWorlds.OFF);
        }
        Utils.setWorlds(Utils.getConfig().getString("worlds"));
        Utils.setRocketMaterial1(Items.getMaterial(Utils.getConfig().getString("rocket.block1.type")));
        Utils.setRocketMaterial2(Items.getMaterial(Utils.getConfig().getString("rocket.block2.type")));
        Utils.setRocketItem(Items.getMaterial(Utils.getConfig().getString("rocket.item.type")));
        Utils.setRocketName(ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getConfig().getString("rocket.item.name")));
        Utils.setParachuteItem(Items.getMaterial(Utils.getConfig().getString("parachute.item.type")));
        Utils.setParachuteMaterial(Items.getMaterial(Utils.getConfig().getString("parachute.block.type")));
        Utils.setParachuteName(ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getConfig().getString("parachute.item.name")));
        Enum[] enumArray = Recipes.ParachuteRecipes.values();
        int n = enumArray.length;
        int n2 = 0;
        while (n2 < n) {
            recipes = enumArray[n2];
            ((Recipes.ParachuteRecipes)recipes).setMaterial(Items.getMaterial(Utils.getConfig().getString("parachute.recipe." + ((Recipes.ParachuteRecipes)recipes).getChar().toUpperCase())));
            ++n2;
        }
        enumArray = Recipes.RocketRecipes.values();
        n = enumArray.length;
        n2 = 0;
        while (n2 < n) {
            recipes = enumArray[n2];
            ((Recipes.RocketRecipes)recipes).setMaterial(Items.getMaterial(Utils.getConfig().getString("rocket.recipe." + ((Recipes.RocketRecipes)recipes).getChar().toUpperCase())));
            ++n2;
        }
        if (Utils.getConfig().getBoolean("recipes")) {
            Recipes.createParachuteRecipe();
            Recipes.createRocketRecipe();
        }
    }

    public void onDisable() {
        instance = null;
    }

    public static Rocket getInstance() {
        return instance;
    }

    private void registerEvents() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        try {
            for (ClassPath.ClassInfo classInfo : ClassPath.from((ClassLoader)this.getClassLoader()).getTopLevelClasses("de.mauricius17.rocket.listener")) {
                Class<?> clazz = Class.forName(classInfo.getName());
                if (!Listener.class.isAssignableFrom(clazz)) continue;
                pluginManager.registerEvents((Listener)clazz.newInstance(), (Plugin)this);
            }
        }
        catch (IOException | ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cThe Listeners could not be registered sucessfuly!");
            e.printStackTrace();
        }
    }

    private void registerCommands() {
        this.getCommand("rocket").setExecutor((CommandExecutor)new RocketCommand());
        this.getCommand("parachute").setExecutor((CommandExecutor)new ParachuteCommand());
    }

    private void loadWarpsConfig() {
        Utils.getWarpsConfiguration().options().header("In this file you can save warps!");
        Utils.getWarpsConfiguration().addDefault("warps", (Object)"");
        Utils.getWarpsConfiguration().options().copyDefaults(true);
        try {
            Utils.getWarpsConfiguration().save(Utils.getWarpFile());
        }
        catch (IOException e) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cThe warps.yml could not be saved! Restart your Server!");
            e.printStackTrace();
        }
    }

    private void loadWarps() {
        String[] warps;
        String[] stringArray = warps = Utils.getWarpsConfiguration().getString("warps").split(";");
        int n = warps.length;
        int n2 = 0;
        while (n2 < n) {
            String w = stringArray[n2];
            Warp warp = new Warp(w);
            Location location = warp.getLocationByConfig();
            if (location != null) {
                warp.setLocation(warp.getLocationByConfig());
                Utils.getWarps().add(warp);
            }
            ++n2;
        }
    }

    private void loadConfig() {
        Utils.getConfig().options().header("In this file you can edit some settings!");
        Utils.getConfig().addDefault("heigh_of_rockettrip", (Object)60);
        Utils.getConfig().addDefault("certain_worlds", (Object)false);
        Utils.getConfig().addDefault("worlds", (Object)"world,world_nether");
        Utils.getConfig().addDefault("recipes", (Object)true);
        Utils.getConfig().addDefault("rocket.item.name", (Object)"&cRocket");
        Utils.getConfig().addDefault("rocket.item.type", (Object)"LEVER");
        Utils.getConfig().addDefault("rocket.block1.type", (Object)"IRON_BLOCK");
        Utils.getConfig().addDefault("rocket.block2.type", (Object)"FENCE");
        Utils.getConfig().addDefault("rocket.recipe.A", (Object)"AIR");
        Utils.getConfig().addDefault("rocket.recipe.B", (Object)"IRON_BLOCK");
        Utils.getConfig().addDefault("rocket.recipe.C", (Object)"AIR");
        Utils.getConfig().addDefault("rocket.recipe.D", (Object)"FENCE");
        Utils.getConfig().addDefault("rocket.recipe.E", (Object)"IRON_BLOCK");
        Utils.getConfig().addDefault("rocket.recipe.F", (Object)"FENCE");
        Utils.getConfig().addDefault("rocket.recipe.G", (Object)"FENCE");
        Utils.getConfig().addDefault("rocket.recipe.H", (Object)"FIREWORK");
        Utils.getConfig().addDefault("rocket.recipe.I", (Object)"FENCE");
        Utils.getConfig().addDefault("parachute.item.name", (Object)"&9Parachute");
        Utils.getConfig().addDefault("parachute.item.type", (Object)"WEB");
        Utils.getConfig().addDefault("parachute.block.type", (Object)"WEB");
        Utils.getConfig().addDefault("parachute.recipe.A", (Object)"AIR");
        Utils.getConfig().addDefault("parachute.recipe.B", (Object)"WEB");
        Utils.getConfig().addDefault("parachute.recipe.C", (Object)"AIR");
        Utils.getConfig().addDefault("parachute.recipe.D", (Object)"WEB");
        Utils.getConfig().addDefault("parachute.recipe.E", (Object)"STRING");
        Utils.getConfig().addDefault("parachute.recipe.F", (Object)"WEB");
        Utils.getConfig().addDefault("parachute.recipe.G", (Object)"STRING");
        Utils.getConfig().addDefault("parachute.recipe.H", (Object)"AIR");
        Utils.getConfig().addDefault("parachute.recipe.I", (Object)"STRING");
        Utils.getConfig().options().copyDefaults(true);
        try {
            Utils.getConfig().save(Utils.getConfigFile());
        }
        catch (IOException e) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cThe config.yml could not be saved! Restart your Server!");
            e.printStackTrace();
        }
    }

    private void loadMessages() {
        Utils.getMessages().options().header("In this file you can edit some messages!");
        Utils.getMessages().addDefault("prefix", (Object)"&8[&5Rocket&8] ");
        Utils.getMessages().addDefault("noPermission", (Object)"&cYou can not do this!");
        Utils.getMessages().addDefault("console", (Object)"&cOnly a player can use that command!");
        Utils.getMessages().addDefault("command.help.header", (Object)"&8==========&5[Rocket&8]==========");
        Utils.getMessages().addDefault("command.help.line01", (Object)"&7/rocket item - &5Get the rocket item");
        Utils.getMessages().addDefault("command.help.line02", (Object)"&7/rocket list- &5List all warps");
        Utils.getMessages().addDefault("command.help.line03", (Object)"&7/rocket <warp> - &5Warp to warp");
        Utils.getMessages().addDefault("command.help.line04", (Object)"&7/rocket set <warp> - &5Set a warp");
        Utils.getMessages().addDefault("command.help.line05", (Object)"&7/rocket remove <warp> - &5Remove a warp");
        Utils.getMessages().addDefault("command.help.footer", (Object)"&8============================");
        Utils.getMessages().addDefault("command.warp.list.header", (Object)"&aThere are the following warps:");
        Utils.getMessages().addDefault("command.warp.list.line01", (Object)"&a> [WARPS]");
        Utils.getMessages().addDefault("command.warp.set.successful", (Object)"&aYou set the warp &e[WARP]&a!");
        Utils.getMessages().addDefault("command.warp.set.failed.save", (Object)"&cThe warp &e[WARP] &ccould not be set!");
        Utils.getMessages().addDefault("command.warp.remove.successful", (Object)"&aYou removed the warp &e[WARP]&a!");
        Utils.getMessages().addDefault("command.warp.remove.failed.save", (Object)"&cThe warp &e[WARP] &ccould not be removed!");
        Utils.getMessages().addDefault("command.warp.remove.failed.notexists", (Object)"&cThe warp &e[WARP] &cdoes not exists!");
        Utils.getMessages().addDefault("command.warp.teleport.successful", (Object)"&aYou are now at warp &e[WARP]&a!");
        Utils.getMessages().addDefault("command.warp.teleport.failed", (Object)"&cThe warp &e[WARP] &cdoes not exists!");
        Utils.getMessages().addDefault("command.warp.teleport.failed_certain_worlds", (Object)"&cIn your world are rockets forbidden!");
        Utils.getMessages().addDefault("rocket.started", (Object)"&aRocket started!");
        Utils.getMessages().addDefault("rocket.already_started", (Object)"&cThe rocket has been started! You can not activate them again!");
        Utils.getMessages().addDefault("rocket.start_while_parachute_is_open", (Object)"&cThe parachute is open! You can not start the rocket!");
        Utils.getMessages().addDefault("rocket.item", (Object)"&aYou got the rocket item!");
        Utils.getMessages().addDefault("parachute.open", (Object)"&aThe parachute is now open!");
        Utils.getMessages().addDefault("parachute.open_fail", (Object)"&cYou can open the parachute only while falling!");
        Utils.getMessages().addDefault("parachute.open_while_rocket_is_started", (Object)"&cYou are inside of the rocket! You can not open the parachute!");
        Utils.getMessages().addDefault("parachute.close", (Object)"&cThe parachute is now closed!");
        Utils.getMessages().addDefault("parachute.item", (Object)"&aYou got the parachute item!");
        Utils.getMessages().options().copyDefaults(true);
        try {
            Utils.getMessages().save(Utils.getMessageFile());
        }
        catch (IOException e) {
            Bukkit.getConsoleSender().sendMessage("\u00a7cThe messages.yml could not be saved! Restart your Server!");
            e.printStackTrace();
        }
    }
}

