/*
 * Decompiled with CFR 0.152.
 */
package de.mauricius17.rocket.rocket;

import de.mauricius17.rocket.utils.Utils;
import org.bukkit.Bukkit;
import org.bukkit.Effect;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Rocket {
    private Plugin instance;
    private Player p;
    private FallingBlock seat;
    private FallingBlock fb;
    private FallingBlock[] blocks;
    private Thread thread;
    private int taskID = -1;

    public Rocket(Plugin instance, Player p) {
        this.instance = instance;
        this.p = p;
        this.blocks = new FallingBlock[6];
    }

    public void build(Location loc) {
        Location temp = loc.clone();
        this.blocks[0] = loc.getWorld().spawnFallingBlock(temp.add(1.0, 0.0, 0.0), Utils.getRocketMaterial2(), (byte)1);
        temp = loc.clone();
        this.blocks[1] = loc.getWorld().spawnFallingBlock(temp.add(-1.0, 0.0, 0.0), Utils.getRocketMaterial2(), (byte)1);
        temp = loc.clone();
        this.blocks[2] = loc.getWorld().spawnFallingBlock(temp.add(0.0, 0.0, -1.0), Utils.getRocketMaterial2(), (byte)1);
        temp = loc.clone();
        this.blocks[3] = loc.getWorld().spawnFallingBlock(temp.add(0.0, 0.0, 1.0), Utils.getRocketMaterial2(), (byte)1);
        temp = loc.clone();
        this.blocks[4] = loc.getWorld().spawnFallingBlock(temp, Utils.getRocketMaterial1(), (byte)1);
        temp = loc.clone();
        this.blocks[5] = loc.getWorld().spawnFallingBlock(temp.add(0.0, 1.0, 0.0), Utils.getRocketMaterial1(), (byte)1);
        temp = loc.clone();
        this.fb = this.blocks[4];
        this.seat = this.blocks[5];
        FallingBlock[] fallingBlockArray = this.blocks;
        int n = this.blocks.length;
        int n2 = 0;
        while (n2 < n) {
            FallingBlock rocket = fallingBlockArray[n2];
            rocket.setDropItem(false);
            ++n2;
        }
    }

    public void addPlayer() {
        this.fb.setPassenger((Entity)this.seat);
        this.seat.setPassenger((Entity)this.p);
    }

    public void start(int blockHigh, final RocketInterface onRocketDestroy) {
        final int y = blockHigh + this.blocks[0].getLocation().getBlockY();
        this.taskID = Bukkit.getScheduler().scheduleSyncRepeatingTask(this.instance, new Runnable(){

            @Override
            public void run() {
                FallingBlock[] fallingBlockArray = Rocket.this.blocks;
                int n = fallingBlockArray.length;
                int n2 = 0;
                while (n2 < n) {
                    FallingBlock rocket = fallingBlockArray[n2];
                    rocket.setVelocity(new Vector(0, 1, 0));
                    ++n2;
                }
                Rocket.this.p.getWorld().playEffect(Rocket.this.p.getLocation().add(0.0, -0.25, 0.0), Effect.MOBSPAWNER_FLAMES, 10);
                Rocket.this.p.playSound(Rocket.this.p.getLocation(), Sound.FIREWORK_LARGE_BLAST, 1.0f, 1.0f);
            }
        }, 0L, 1L);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (true) {
                    Location loc = Rocket.this.p.getLocation();
                    loc.setY(loc.getY() + 2.0);
                    FallingBlock[] fallingBlockArray = Rocket.this.blocks;
                    int n = fallingBlockArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        FallingBlock rocket = fallingBlockArray[n2];
                        Location b = rocket.getLocation();
                        b.setY(b.getY() + 1.0);
                        if (b.getBlock().getType() != Material.AIR) {
                            Bukkit.getScheduler().scheduleSyncDelayedTask(Rocket.this.instance, new Runnable(){

                                @Override
                                public void run() {
                                    if (onRocketDestroy != null) {
                                        onRocketDestroy.onRocketDestroy();
                                    }
                                }
                            });
                            Rocket.this.despawn();
                            Rocket.this.thread.stop();
                            return;
                        }
                        ++n2;
                    }
                    if (Rocket.this.p.getLocation().getY() >= 250.0) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask(Rocket.this.instance, new Runnable(){

                            @Override
                            public void run() {
                                if (onRocketDestroy != null) {
                                    onRocketDestroy.onRocketDestroy();
                                }
                            }
                        });
                        Rocket.this.despawn();
                        Rocket.this.thread.stop();
                        return;
                    }
                    if (Rocket.this.blocks[0].getLocation().getY() > (double)y) {
                        Bukkit.getScheduler().scheduleSyncDelayedTask(Rocket.this.instance, new Runnable(){

                            @Override
                            public void run() {
                                if (onRocketDestroy != null) {
                                    onRocketDestroy.onRocketDestroy();
                                }
                            }
                        });
                        Rocket.this.despawn();
                        Rocket.this.thread.stop();
                        return;
                    }
                    try {
                        Thread.sleep(100L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        });
        this.thread.start();
    }

    public void despawn() {
        FallingBlock[] fallingBlockArray = this.blocks;
        int n = this.blocks.length;
        int n2 = 0;
        while (n2 < n) {
            FallingBlock rocket = fallingBlockArray[n2];
            rocket.remove();
            ++n2;
        }
        if (Utils.getRocket().containsKey(this.p.getUniqueId())) {
            Utils.getRocket().remove(this.p.getUniqueId());
        }
        if (this.taskID != -1) {
            Bukkit.getScheduler().cancelTask(this.taskID);
        }
        if (this.thread != null && this.thread.isAlive()) {
            this.thread.stop();
        }
    }

    public static interface RocketInterface {
        public void onRocketDestroy();
    }
}

