/*
 * Decompiled with CFR 0.152.
 */
package de.mauricius17.rocket.parachute;

import de.mauricius17.rocket.parachute.ParachuteConfigurations;
import de.mauricius17.rocket.system.Rocket;
import de.mauricius17.rocket.utils.Utils;
import org.bukkit.ChatColor;
import org.bukkit.GameMode;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class Parachute
implements Runnable {
    private Player player;
    private Block b;
    private Block[] direction = new Block[11];
    private Block[] ndirection = new Block[11];
    private ParachuteConfigurations direction1;
    private boolean stop = false;
    private double slow = -0.05;
    private double forwardSpeed = 0.2;

    public Parachute(Player player, Block b) {
        this.player = player;
        this.b = b;
        this.direction1 = new ParachuteConfigurations(player);
        this.updateVectors();
    }

    @Override
    public void run() {
        if (this.b.getWorld().getBlockAt(this.b.getX(), this.b.getY() - 1, this.b.getZ()).getType() == Material.AIR) {
            this.player.setVelocity(this.getVector());
            this.player.setFallDistance(0.0f);
            this.ndirection = this.direction1.getDirection();
            if (!this.isSameShoot()) {
                this.remove();
                this.displayShoot();
            }
            this.b = this.player.getLocation().getBlock();
            if (!this.stop) {
                Rocket.getInstance().getServer().getScheduler().scheduleSyncDelayedTask((Plugin)Rocket.getInstance(), (Runnable)this, 1L);
            } else {
                this.remove();
            }
        } else {
            this.close();
            if (Utils.getParachute().containsKey(this.player.getUniqueId())) {
                Utils.getParachute().remove(this.player.getUniqueId());
            }
        }
    }

    public void updateVectors() {
        this.slow = Utils.getSlow();
        this.forwardSpeed = Utils.getForwardSpeed();
    }

    public void open() {
        this.player.setFlying(false);
        this.player.setAllowFlight(false);
        this.run();
        this.player.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("parachute.open")));
    }

    public void close() {
        this.stop = true;
        this.player.setFlying(false);
        if (this.player.getGameMode() == GameMode.SURVIVAL || this.player.getGameMode() == GameMode.ADVENTURE) {
            this.player.setAllowFlight(false);
        }
        this.remove();
        this.player.sendMessage(String.valueOf(Utils.getPrefix()) + ChatColor.translateAlternateColorCodes((char)'&', (String)Utils.getMessages().getString("parachute.close")));
    }

    private void remove() {
        try {
            int i = 0;
            while (i < this.direction.length) {
                if (this.direction[i] != null && this.direction[i].getType() == Utils.getParachuteMaterial()) {
                    this.direction[i].setType(Material.AIR);
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private boolean isSameShoot() {
        try {
            if (this.direction[0] != null) {
                return this.direction[1] == this.ndirection[1] && this.direction[6] == this.ndirection[6] || this.direction[1] == this.ndirection[1] && this.direction[6] == this.ndirection[6];
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Vector getVector() {
        double rotation = (this.player.getLocation().getYaw() - 90.0f) % 360.0f;
        if (rotation < 0.0) {
            rotation += 360.0;
        }
        return new Vector(-this.forwardSpeed * Math.cos(Math.toRadians(rotation)), this.slow, -(this.forwardSpeed * Math.sin(Math.toRadians(rotation))));
    }

    private void displayShoot() {
        this.direction = this.ndirection;
        try {
            int i = 0;
            while (i < this.direction.length) {
                if (this.direction[i].getType() == Material.AIR) {
                    this.direction[i].setType(Utils.getParachuteMaterial());
                }
                ++i;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

