/*
 * Decompiled with CFR 0.152.
 */
package it.onlydehbest.bounty.listeners;

import it.onlydehbest.bounty.UltimateBounty;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.Statistic;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class PlayerListener
implements Listener {
    private final UltimateBounty plugin;

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.plugin.getDatabase().initializeAccount(player.getName());
    }

    @EventHandler
    public void onPlayerQuitEvent(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getDatabase().hasBounty(player.getName())) {
            this.plugin.getDatabase().addBounty(player.getName(), this.plugin.getDatabase().getBounty(player.getName()));
        }
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        Player killer = player.getKiller();
        if (killer == null) {
            return;
        }
        List worlds = this.plugin.getConfig().getStringList("settings.blacklisted-worlds.worlds");
        if (this.plugin.getConfig().getBoolean("settings.blacklisted-worlds.enabled") && worlds.contains(player.getWorld().getName())) {
            return;
        }
        if (this.plugin.getConfig().getBoolean("settings.random-bounty-on-streaks.enabled") && killer.getStatistic(Statistic.PLAYER_KILLS) % this.plugin.getConfig().getInt("settings.random-bounty-on-streaks.min-streak") == 0) {
            this.plugin.getDatabase().randomBounty(killer);
        }
        if (this.plugin.getDatabase().hasBounty(player.getName())) {
            this.plugin.getEconomy().depositPlayer((OfflinePlayer)killer, (double)this.plugin.getDatabase().getBounty(player.getName()));
            if (this.plugin.getDatabase().hasBounty(player.getName())) {
                killer.sendMessage(this.plugin.getConfig().getString("messages.bounty-claimed").replace("&", "\u00a7").replace("{player}", player.getName()).replace("{amount}", String.valueOf(this.plugin.getDatabase().getBounty(player.getName()))));
                Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(this.plugin.getConfig().getString("messages.bounty-claimed-announce").replace("&", "\u00a7").replace("{player}", player.getName()).replace("{amount}", String.valueOf(this.plugin.getDatabase().getBounty(player.getName())))));
            }
            this.plugin.getDatabase().removeBounty(player.getName(), this.plugin.getDatabase().getBounty(player.getName()));
            if (this.plugin.getConfig().getBoolean("settings.lighting-strike-on-death")) {
                killer.getLocation().getWorld().strikeLightning(killer.getLocation());
            }
            if (this.plugin.getConfig().getBoolean("settings.sound-on-death.enabled")) {
                killer.getLocation().getWorld().playSound(killer.getLocation(), Sound.valueOf((String)this.plugin.getConfig().getString("settings.sound-on-death.sound")), 100.0f, 100.0f);
            }
        }
    }

    public PlayerListener(UltimateBounty plugin) {
        this.plugin = plugin;
    }
}

