/*
 * Decompiled with CFR 0.152.
 */
package it.onlydehbest.bounty.database;

import it.onlydehbest.bounty.UltimateBounty;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadLocalRandom;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class Database {
    private final UltimateBounty plugin;
    Connection connection;
    private final HashMap<String, Integer> bountyHashMap = new HashMap();

    public Database(UltimateBounty plugin, String databasePath) throws Exception {
        this.plugin = plugin;
        Class.forName("org.sqlite.JDBC");
        this.connection = DriverManager.getConnection("jdbc:sqlite:" + databasePath);
        this.setup();
        this.loadBounty();
    }

    private void setup() {
        CompletableFuture.runAsync(() -> {
            try {
                Statement statement = this.connection.createStatement();
                statement.executeUpdate("CREATE TABLE IF NOT EXISTS players_bounty(PlayerName TEXT PRIMARY KEY, Bounty NUMERIC);");
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }, this.plugin.getExecutor());
    }

    public boolean hasRegisteredAccount(String username) {
        return this.bountyHashMap.containsKey(username);
    }

    public void initializeAccount(String username) {
        if (this.hasRegisteredAccount(username)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                Statement statement = this.connection.createStatement();
                statement.executeUpdate("INSERT INTO players_bounty(PlayerName, Bounty) VALUES ('" + username + "', 0);");
                statement.close();
                this.bountyHashMap.put(username, 0);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }, this.plugin.getExecutor());
    }

    public void updateBounty(String username, int bounty) {
        if (!this.hasRegisteredAccount(username)) {
            return;
        }
        CompletableFuture.runAsync(() -> {
            try {
                Statement statement = this.connection.createStatement();
                statement.executeUpdate("UPDATE players_bounty SET Bounty=" + bounty + " WHERE PlayerName='" + username + "';");
                statement.close();
                this.bountyHashMap.replace(username, bounty);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }, this.plugin.getExecutor());
    }

    public void loadBounty() {
        CompletableFuture.runAsync(() -> {
            try {
                Statement statement = this.connection.createStatement();
                ResultSet queryResult = statement.executeQuery("SELECT * FROM players_bounty;");
                this.bountyHashMap.clear();
                while (queryResult.next()) {
                    this.bountyHashMap.put(queryResult.getString(1), queryResult.getInt(2));
                }
                queryResult.close();
                statement.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }, this.plugin.getExecutor());
    }

    public int getBounty(String username) {
        return this.bountyHashMap.getOrDefault(username, 0);
    }

    public boolean hasBounty(String username) {
        return this.getBounty(username) > 0;
    }

    public void addBounty(String username, int amount) {
        this.updateBounty(username, this.getBounty(username) + amount);
    }

    public void removeBounty(String username, int amount) {
        this.updateBounty(username, this.getBounty(username) - amount);
    }

    public void randomBounty(Player player) {
        int amount = ThreadLocalRandom.current().nextInt(this.plugin.getConfig().getInt("settings.random-bounty-on-streaks.random-money-min"), this.plugin.getConfig().getInt("settings.random-bounty-on-streaks.random-money-max"));
        this.addBounty(player.getName(), this.hasBounty(player.getName()) ? this.getBounty(player.getName()) + amount : amount);
        Bukkit.getOnlinePlayers().forEach(p -> p.sendMessage(this.plugin.getConfig().getString("messages.bounty-announce").replace("&", "\u00a7").replace("{player}", player.getName()).replace("{amount}", String.valueOf(amount))));
    }

    public void close() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public Database(UltimateBounty plugin) {
        this.plugin = plugin;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public HashMap<String, Integer> getBountyHashMap() {
        return this.bountyHashMap;
    }
}

