/*
 * Decompiled with CFR 0.152.
 */
package it.onlydehbest.bounty;

import it.onlydehbest.bounty.commands.BountyCommand;
import it.onlydehbest.bounty.commands.UltimateBountyCommand;
import it.onlydehbest.bounty.database.Database;
import it.onlydehbest.bounty.hook.PlaceholderAPIHook;
import it.onlydehbest.bounty.listeners.PlayerListener;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.ServicePriority;
import org.bukkit.plugin.java.JavaPlugin;

public final class UltimateBounty
extends JavaPlugin {
    private Database database;
    private ExecutorService executor;
    public Economy economy = null;
    private final PlaceholderAPIHook placeholderAPIHook = new PlaceholderAPIHook();

    public void onLoad() {
        if (this.getServer().getPluginManager().getPlugin("Vault") != null) {
            this.getServer().getServicesManager().register(Economy.class, (Object)((Economy)this.getServer().getPluginManager().getPlugin("Vault")), (Plugin)this, ServicePriority.Normal);
        }
    }

    public void onEnable() {
        this.saveDefaultConfig();
        if (!this.setupEconomy()) {
            this.getLogger().severe(String.format("[%s] - Disabled due to no Vault dependency found!", this.getDescription().getName()));
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.executor = new ForkJoinPool(3, pool -> {
            ForkJoinWorkerThread worker = ForkJoinPool.defaultForkJoinWorkerThreadFactory.newThread(pool);
            worker.setDaemon(true);
            worker.setName("plugin-executor");
            return worker;
        }, (t, e) -> e.printStackTrace(), true);
        try {
            this.database = new Database(this, this.getDataFolder().getAbsolutePath() + "/database.db");
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.placeholderAPIHook.register();
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(this), (Plugin)this);
        this.getCommand("bounty").setExecutor((CommandExecutor)new BountyCommand(this));
        this.getCommand("ultimatebounty").setExecutor((CommandExecutor)new UltimateBountyCommand(this));
    }

    private boolean setupEconomy() {
        if (this.getServer().getPluginManager().getPlugin("Vault") == null) {
            return false;
        }
        RegisteredServiceProvider rsp = this.getServer().getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            return false;
        }
        this.economy = (Economy)rsp.getProvider();
        return this.economy != null;
    }

    public void onDisable() {
        if (this.database != null) {
            this.database.close();
        }
        if (this.economy != null) {
            Bukkit.getServicesManager().unregister(Economy.class, (Object)this.economy);
        }
        try {
            this.executor.shutdown();
            if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                this.executor.shutdownNow();
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.getLogger().severe("Thread pool did not terminate!");
                }
            }
        }
        catch (InterruptedException ex) {
            this.getLogger().log(Level.SEVERE, "Error while shutting down thread pool!", ex);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public ExecutorService getExecutor() {
        return this.executor;
    }

    public Economy getEconomy() {
        return this.economy;
    }

    public PlaceholderAPIHook getPlaceholderAPIHook() {
        return this.placeholderAPIHook;
    }
}

