/*
 * Decompiled with CFR 0.152.
 */
package avampost.avampost.worldguard;

import avampost.avampost.Main;
import avampost.avampost.paper.AvampostCommand;
import avampost.avampost.utility.Parser;
import avampost.avampost.worldguard.WGAvampost;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldguard.LocalPlayer;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.association.RegionAssociable;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.Flags;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.session.MoveType;
import com.sk89q.worldguard.session.Session;
import com.sk89q.worldguard.session.handler.FlagValueChangeHandler;
import com.sk89q.worldguard.session.handler.Handler;
import java.util.Objects;
import org.bukkit.Bukkit;

public class WGAvampostEntry
extends FlagValueChangeHandler<StateFlag.State> {
    public static final Factory FACTORY = new Factory();
    private static final long MESSAGE_THRESHOLD = 2000L;
    private String storedMessage;
    private boolean exitViaTeleport = false;
    private long lastMessage;
    Main instance = (Main)Main.getPlugin(Main.class);

    public WGAvampostEntry(Session session) {
        super(session, (Flag)Main.AVAMPOST_REQUIREMENTS_FLAG_);
    }

    private void update(LocalPlayer localPlayer, ApplicableRegionSet set, boolean allowed) {
        if (!allowed) {
            this.storedMessage = AvampostCommand.messagesFile.getString("worldguard-avampost-entry-not-allowed");
            this.exitViaTeleport = set.testState((RegionAssociable)localPlayer, new StateFlag[]{Flags.EXIT_VIA_TELEPORT});
        }
    }

    private void sendMessage(LocalPlayer player) {
        long now = System.currentTimeMillis();
        if (now - this.lastMessage > 2000L && this.storedMessage != null && !this.storedMessage.isEmpty()) {
            if (Bukkit.getPlayer((String)player.getName()) != null) {
                Bukkit.getPlayer((String)player.getName()).sendMessage(Parser.parseKyori(this.storedMessage));
            }
            this.lastMessage = now;
        }
    }

    protected void onInitialValue(LocalPlayer player, ApplicableRegionSet set, StateFlag.State value) {
        this.update(player, set, StateFlag.test((StateFlag.State[])new StateFlag.State[]{value}));
    }

    protected boolean onSetValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State currentValue, StateFlag.State lastValue, MoveType moveType) {
        Boolean override;
        if (this.getSession().getManager().hasBypass(player, (World)from.getExtent())) {
            return true;
        }
        if (player.hasPermission("permesso.dell'avamposto")) {
            return true;
        }
        boolean lastAllowed = StateFlag.test((StateFlag.State[])new StateFlag.State[]{lastValue});
        boolean allowed = StateFlag.test((StateFlag.State[])new StateFlag.State[]{currentValue});
        if (!(!allowed || lastAllowed || moveType.isTeleport() && this.exitViaTeleport || !moveType.isCancellable() || (override = (Boolean)toSet.queryValue((RegionAssociable)player, (Flag)Flags.EXIT_OVERRIDE)) != null && override.booleanValue())) {
            Bukkit.getPlayer((String)player.getName()).sendMessage(Parser.parseKyori(this.storedMessage));
            return false;
        }
        this.update(player, toSet, allowed);
        return true;
    }

    protected boolean onAbsentValue(LocalPlayer player, Location from, Location to, ApplicableRegionSet toSet, StateFlag.State lastValue, MoveType moveType) {
        if (this.getSession().getManager().hasBypass(player, (World)from.getExtent())) {
            return true;
        }
        boolean lastAllowed = StateFlag.test((StateFlag.State[])new StateFlag.State[]{lastValue});
        for (ProtectedRegion region : toSet) {
            if (region.getFlag((Flag)Main.AVAMPOST_REQUIREMENTS_FLAG_) == null) continue;
            String AvampostID = WGAvampost.getAvampostoIdFromRegionId(region.getId());
            if (AvampostCommand.avampostFile.getBoolean("avamposts." + AvampostID + ".requirements.requirements-to-join.enabled")) {
                Boolean override;
                if (player.hasPermission(AvampostCommand.avampostFile.getString("avamposts." + AvampostID + ".requirements.requirements-to-join.permission"))) {
                    return true;
                }
                if (!(lastAllowed || !moveType.isCancellable() || (override = (Boolean)toSet.queryValue((RegionAssociable)player, (Flag)Flags.EXIT_OVERRIDE)) != null && override.booleanValue())) {
                    this.sendMessage(player);
                    if (Bukkit.getPlayer((String)player.getName()) != null) {
                        Bukkit.getPlayer((String)player.getName()).teleportAsync(Objects.requireNonNull(this.instance.getConfig().getLocation("spawn-point.location")));
                    }
                    return false;
                }
            }
            if (!player.hasPermission("pryma.avampost")) continue;
            return true;
        }
        return true;
    }

    public static class Factory
    extends Handler.Factory<WGAvampostEntry> {
        public WGAvampostEntry create(Session session) {
            return new WGAvampostEntry(session);
        }
    }
}

