/*
 * Decompiled with CFR 0.152.
 */
package avampost.avampost.utility;

import avampost.avampost.Main;
import avampost.avampost.utility.LogLevel;
import avampost.avampost.utility.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import org.bukkit.configuration.file.YamlConfiguration;

public class FileManager {
    Main plugin = (Main)Main.getPlugin(Main.class);

    public void caricaFiles() {
        this.plugin.getConfig().options().copyDefaults();
        this.plugin.saveDefaultConfig();
        if (this.plugin.getConfig().getBoolean("developer-mode")) {
            Logger.log(LogLevel.WARNING, "Developer mode enabled");
            this.overrideFile("messages.yml", "");
        }
        this.overrideFileIfNotExist("avampost.yml", "");
        this.overrideFileIfNotExist("messages.yml", "");
        this.loadFile("messages.yml", "");
        this.loadFile("avampost.yml", "");
    }

    private void loadFile(String nome, String Folder) {
        Path Path2 = Paths.get(String.valueOf(this.plugin.getDataFolder()) + "/" + Folder, new String[0]);
        File file = new File(String.valueOf(this.plugin.getDataFolder()) + "/" + Folder, nome);
        if (!file.exists()) {
            try {
                if (!Files.exists(Path2, new LinkOption[0])) {
                    Files.createDirectory(Path2, new FileAttribute[0]);
                }
                if (Files.exists(Path2, new LinkOption[0])) {
                    YamlConfiguration.loadConfiguration((File)file);
                    Logger.log(LogLevel.INFO, "File: " + nome + " loaded with success");
                }
                file.createNewFile();
                Logger.log(LogLevel.INFO, "File: " + nome + " created with success");
            }
            catch (Exception e) {
                Logger.log(LogLevel.ERROR, "Error during loading of file: " + nome);
            }
        } else {
            Logger.log(LogLevel.INFO, "File: " + nome + " loaded with success");
            YamlConfiguration.loadConfiguration((File)file);
        }
    }

    private void overrideFile(String nome, String Folder) {
        YamlConfiguration internalConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(this.plugin.getResource(nome))));
        try {
            internalConfig.save(new File(String.valueOf(this.plugin.getDataFolder()) + "/" + Folder, nome));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void overrideFileIfNotExist(String nome, String Folder) {
        File file = new File(String.valueOf(this.plugin.getDataFolder()) + "/" + Folder, nome);
        YamlConfiguration internalConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(Objects.requireNonNull(this.plugin.getResource(nome))));
        try {
            if (file.exists()) {
                Logger.log(LogLevel.INFO, "File exist: " + nome + " not override");
            } else {
                internalConfig.save(new File(String.valueOf(this.plugin.getDataFolder()) + "/" + Folder, nome));
                Logger.log(LogLevel.INFO, "File override: " + nome + " because not exist");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

