/*
 * Decompiled with CFR 0.152.
 */
package avampost.avampost.utility;

import avampost.avampost.Main;
import avampost.avampost.paper.AvampostCommand;
import avampost.avampost.spigot.AvampostCommandSpigot;
import avampost.avampost.utility.LogLevel;
import avampost.avampost.utility.Logger;
import java.lang.reflect.Field;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;

public class CommandManager {
    Main plugin = (Main)Main.getPlugin(Main.class);

    public void registerCommands() {
        if (this.plugin.getServerType() == Main.ServerType.PAPER) {
            AvampostCommand command = new AvampostCommand("avampost");
            Logger.log(LogLevel.SUCCESS, "Paper command registered");
            CommandMap commandMap = this.getCommandMap();
            if (commandMap != null) {
                commandMap.register("avampost", (Command)command);
            }
        } else if (this.plugin.getServerType() == Main.ServerType.SPIGOT) {
            PluginCommand pluginCommand = this.plugin.getCommand("avampost");
            Logger.log(LogLevel.SUCCESS, "Spigot command registered");
            if (pluginCommand != null) {
                pluginCommand.setExecutor((CommandExecutor)new AvampostCommandSpigot());
                pluginCommand.setTabCompleter((TabCompleter)new AvampostCommandSpigot());
            } else {
                Logger.log(LogLevel.ERROR, "Error during command  (Spigot)");
            }
        }
    }

    private CommandMap getCommandMap() {
        try {
            Field commandMapField = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            commandMapField.setAccessible(true);
            return (CommandMap)commandMapField.get(Bukkit.getServer());
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            Logger.log(LogLevel.ERROR, "Error during command registration" + e.getMessage());
            return null;
        }
    }
}

