/*
 * Decompiled with CFR 0.152.
 */
package avampost.avampost.paper;

import avampost.avampost.AvampostFileManager;
import avampost.avampost.Checker;
import avampost.avampost.Main;
import avampost.avampost.paper.events.KillMobEvent;
import avampost.avampost.utility.LogLevel;
import avampost.avampost.utility.Logger;
import avampost.avampost.utility.Parser;
import avampost.avampost.worldguard.WGAvampost;
import io.lumine.mythic.api.mobs.MythicMob;
import io.lumine.mythic.bukkit.BukkitAdapter;
import io.lumine.mythic.bukkit.MythicBukkit;
import io.lumine.mythic.core.mobs.ActiveMob;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class AvampostCommand
extends Command {
    static Main plugin = (Main)Main.getPlugin(Main.class);
    public static HashMap<String, ArrayList<UUID>> listEntity = new HashMap();
    public static YamlConfiguration messagesFile = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "messages.yml"));
    public static YamlConfiguration avampostFile = YamlConfiguration.loadConfiguration((File)new File(plugin.getDataFolder(), "avampost.yml"));
    public static HashMap<String, Long> cooldown = new HashMap();
    AvampostFileManager avampostFileManager = new AvampostFileManager();

    public AvampostCommand(@NotNull String name) {
        super(name);
        this.setAliases(List.of("avamposto", "avampost"));
    }

    @NotNull
    public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String label, String[] args) {
        ConfigurationSection section;
        if (args.length == 1) {
            return List.of("admin", "help");
        }
        if (args.length == 2 && args[0].equals("admin")) {
            return List.of("reload", "start", "cooldown", "edit");
        }
        if (args.length == 3 && (args[1].equals("start") || args[1].equals("cooldown")) && (section = avampostFile.getConfigurationSection("avamposts")) != null) {
            return new ArrayList<String>(section.getKeys(false));
        }
        return Collections.emptyList();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, @NotNull String[] args) {
        if (sender instanceof ConsoleCommandSender) {
            if (args.length > 0) {
                switch (args[0]) {
                    case "reload": {
                        this.avampostFileManager.consoleReload();
                        break;
                    }
                    case "help": {
                        for (String s : messagesFile.getStringList("console-help")) {
                            Logger.log(LogLevel.INFO, s);
                        }
                        break;
                    }
                }
            } else {
                for (String s : messagesFile.getStringList("console-help")) {
                    Logger.log(LogLevel.INFO, s);
                }
            }
        }
        if (!(sender instanceof Player)) return true;
        Player player = (Player)sender;
        if (args.length > 0) {
            switch (args[0]) {
                case "help": {
                    for (String s : messagesFile.getStringList("help")) {
                        player.sendMessage(Parser.parseKyori(s));
                    }
                    return true;
                }
                case "admin": {
                    if (player.hasPermission("avampost.admin")) {
                        if (args.length > 1) {
                            switch (args[1]) {
                                case "reload": {
                                    AvampostFileManager avampostFileManager = new AvampostFileManager();
                                    avampostFileManager.check();
                                    try {
                                        messagesFile.options().configuration().load(new File(String.valueOf(plugin.getDataFolder()) + "/", "messages.yml"));
                                        avampostFile.options().configuration().load(new File(String.valueOf(plugin.getDataFolder()) + "/", "avampost.yml"));
                                        plugin.reloadConfig();
                                        plugin.saveConfig();
                                        Checker checker = new Checker();
                                        checker.checkerMessages();
                                        player.sendMessage(Parser.parseKyori(messagesFile.getString("reload-success")));
                                        return true;
                                    }
                                    catch (IOException | InvalidConfigurationException e) {
                                        player.sendMessage(Parser.parseKyori(messagesFile.getString("reload-failure")));
                                        throw new RuntimeException(e);
                                    }
                                }
                                case "start": 
                                case "inizia": {
                                    if (args.length > 2) {
                                        String evento = args[2];
                                        if (KillMobEvent.eventiAttivi.contains(evento)) {
                                            player.sendMessage(Parser.parseKyori(messagesFile.getString("avampost-already-started")));
                                            return true;
                                        }
                                        AvampostCommand.iniziaEvento(evento, player, avampostFile.getString("avamposts." + evento + ".region"));
                                        return true;
                                    }
                                    player.sendMessage(Parser.parseKyori(messagesFile.getString("admin-start-help")));
                                    return true;
                                }
                                case "cooldown": {
                                    if (args.length > 2) {
                                        String evento = args[2];
                                        if (cooldown.containsKey(evento)) {
                                            cooldown.remove(evento);
                                            player.sendMessage(Parser.parseKyori(Objects.requireNonNull(messagesFile.getString("cooldown-removed")).replace("%avampost%", evento)));
                                            return true;
                                        }
                                        player.sendMessage(Parser.parseKyori(messagesFile.getString("avampost-not-in-cooldown")));
                                        return true;
                                    }
                                    player.sendMessage(Parser.parseKyori(messagesFile.getString("admin-cooldown-help")));
                                    return true;
                                }
                                case "edit": 
                                case "config": 
                                case "configurazione": 
                                case "editor": {
                                    AvampostCommand.openConfigGUI(player);
                                    return true;
                                }
                            }
                            for (String s : messagesFile.getStringList("help")) {
                                player.sendMessage(Parser.parseKyori(s));
                            }
                            return true;
                        } else {
                            for (String s : messagesFile.getStringList("help")) {
                                player.sendMessage(Parser.parseKyori(s));
                            }
                        }
                        return true;
                    }
                    player.sendMessage(Parser.parseKyori(messagesFile.getString("no-permission")));
                }
            }
            return true;
        }
        player.sendMessage(Parser.parseKyori(messagesFile.getString("avampost-usage")));
        return true;
    }

    public static void iniziaEvento(String idEvento, Player player, String regionID) {
        if (!plugin.isPremiumVersion().booleanValue() && avampostFile.getConfigurationSection("avamposts").getKeys(false).size() > 1) {
            player.sendMessage(Parser.parseKyori(messagesFile.getString("need-premium-version")));
            Logger.log(LogLevel.ERROR, messagesFile.getString("need-premium-version"));
            return;
        }
        if (!KillMobEvent.eventiAttivi.contains(regionID)) {
            Logger.log(LogLevel.DEBUG, String.valueOf(cooldown.containsKey(idEvento)));
            if (cooldown.containsKey(idEvento)) {
                long timeleft = (cooldown.get(idEvento) - System.currentTimeMillis()) / 1000L;
                if (timeleft <= 0L) {
                    Logger.log(LogLevel.DEBUG, "Avampost: " + idEvento + " its not in cooldown");
                    AvampostCommand.startEvent(idEvento, regionID);
                } else {
                    player.sendMessage(Parser.parseKyori(Objects.requireNonNull(messagesFile.getString("avampost-cooldown")).replace("%timeleft%", String.valueOf(timeleft))));
                    Logger.log(LogLevel.DEBUG, " Avampost " + idEvento + " its in cooldown for " + timeleft + " seconds");
                }
            } else {
                Logger.log(LogLevel.DEBUG, "Avampost " + idEvento + " its not in cooldown");
                AvampostCommand.startEvent(idEvento, regionID);
            }
        }
    }

    private static void startEvent(String idEvento, String regionID) {
        MythicMob miniBoss = MythicBukkit.inst().getMobManager().getMythicMob(avampostFile.getString("avamposts." + idEvento + ".boss.id")).orElse(null);
        MythicMob mob1 = MythicBukkit.inst().getMobManager().getMythicMob(avampostFile.getString("avamposts." + idEvento + ".mobs.mob1.id")).orElse(null);
        MythicMob mob2 = MythicBukkit.inst().getMobManager().getMythicMob(avampostFile.getString("avamposts." + idEvento + ".mobs.mob2.id")).orElse(null);
        MythicMob mob3 = MythicBukkit.inst().getMobManager().getMythicMob(avampostFile.getString("avamposts." + idEvento + ".mobs.mob3.id")).orElse(null);
        MythicMob mob4 = MythicBukkit.inst().getMobManager().getMythicMob(avampostFile.getString("avamposts." + idEvento + ".mobs.mob4.id")).orElse(null);
        if (mob1 != null && mob2 != null && mob3 != null && mob4 != null && miniBoss != null) {
            ActiveMob MiniBoss = miniBoss.spawn(BukkitAdapter.adapt((Location)avampostFile.getLocation("avamposts." + idEvento + ".boss.location")), (double)avampostFile.getInt("avamposts." + idEvento + ".boss.level"));
            ActiveMob Mob = mob1.spawn(BukkitAdapter.adapt((Location)avampostFile.getLocation("avamposts." + idEvento + ".mobs.mob1.location")), (double)avampostFile.getInt("avamposts." + idEvento + ".mobs.mob1.level"));
            ActiveMob Mob2 = mob2.spawn(BukkitAdapter.adapt((Location)avampostFile.getLocation("avamposts." + idEvento + ".mobs.mob2.location")), (double)avampostFile.getInt("avamposts." + idEvento + ".mobs.mob2.level"));
            ActiveMob Mob3 = mob3.spawn(BukkitAdapter.adapt((Location)avampostFile.getLocation("avamposts." + idEvento + ".mobs.mob3.location")), (double)avampostFile.getInt("avamposts." + idEvento + ".mobs.mob3.level"));
            ActiveMob Mob4 = mob4.spawn(BukkitAdapter.adapt((Location)avampostFile.getLocation("avamposts." + idEvento + ".mobs.mob4.location")), (double)avampostFile.getInt("avamposts." + idEvento + ".mobs.mob4.level"));
            ArrayList<ActiveMob> entitaAttive = new ArrayList<ActiveMob>(Arrays.asList(MiniBoss, Mob, Mob2, Mob3, Mob4));
            ArrayList<UUID> entitaEvento = new ArrayList<UUID>();
            for (int i = 0; i < 5; ++i) {
                UUID entityUUID = entitaAttive.get(i).getEntity().getUniqueId();
                entitaEvento.add(entityUUID);
            }
            listEntity.put(regionID, entitaEvento);
            KillMobEvent.eventiAttivi.add(regionID);
            long tempoCooldown = plugin.getConfig().getLong("cooldown-conquer") * 1000L;
            cooldown.put(idEvento, System.currentTimeMillis() + tempoCooldown);
            Logger.log(LogLevel.DEBUG, entitaEvento.toString());
        } else {
            Logger.log(LogLevel.ERROR, "One of this mobs doesn't exist check it: " + String.valueOf(miniBoss) + " mob: " + String.valueOf(mob1) + " mob2: " + String.valueOf(mob2) + " mob3: " + String.valueOf(mob3) + " mob4: " + String.valueOf(mob4));
        }
    }

    public static void blockEvent(String idEvento) {
        if (KillMobEvent.eventiAttivi.contains(idEvento)) {
            for (int i = 0; i < listEntity.get(idEvento).size(); ++i) {
                UUID entityUUID = listEntity.get(idEvento).get(i);
                Entity entity = Bukkit.getEntity((UUID)entityUUID);
                if (entity == null) continue;
                entity.remove();
            }
            WGAvampost.partecipantiEvento.get(idEvento).clear();
            listEntity.remove(idEvento);
            KillMobEvent.eventiAttivi.remove(idEvento);
            Logger.log(LogLevel.INFO, "Avampost region: " + idEvento + " has been blocked & finished.");
        }
    }

    public static void openConfigGUI(Player player) {
        Bukkit.getScheduler().runTask((Plugin)plugin, () -> {
            Inventory invConfig = Bukkit.createInventory(null, (int)9, (Component)Parser.parseKyori(messagesFile.getString("config-gui-title")));
            ItemStack createEvent = new ItemStack(Material.LIME_STAINED_GLASS_PANE);
            ItemStack modifyEvent = new ItemStack(Material.YELLOW_STAINED_GLASS_PANE);
            ItemMeta createEventMeta = createEvent.getItemMeta();
            ItemMeta modifyEventMeta = modifyEvent.getItemMeta();
            createEventMeta.displayName(Parser.parseKyori(messagesFile.getString("config-gui-create-event-item")));
            modifyEventMeta.displayName(Parser.parseKyori(messagesFile.getString("config-gui-modify-event-item")));
            createEvent.setItemMeta(createEventMeta);
            modifyEvent.setItemMeta(modifyEventMeta);
            invConfig.setItem(0, createEvent);
            invConfig.setItem(1, modifyEvent);
            player.openInventory(invConfig);
        });
    }
}

