/*
 * Decompiled with CFR 0.152.
 */
package avampost.avampost;

import avampost.avampost.AvampostFileManager;
import avampost.avampost.Metrics;
import avampost.avampost.utility.CommandManager;
import avampost.avampost.utility.EventManager;
import avampost.avampost.utility.FileManager;
import avampost.avampost.utility.LogLevel;
import avampost.avampost.utility.Logger;
import avampost.avampost.worldguard.WGAvampost;
import avampost.avampost.worldguard.WGAvampostEntry;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.BooleanFlag;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.RegionGroup;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.session.SessionManager;
import com.sk89q.worldguard.session.handler.Handler;
import java.io.File;
import java.io.IOException;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    Main plugin;
    EventManager eventManager;
    CommandManager commandManager;
    FileManager fileManager;
    AvampostFileManager avampostFileManager;
    public static BooleanFlag AVAMPOST_FLAG_;
    public static StateFlag AVAMPOST_REQUIREMENTS_FLAG_;
    public boolean ispremiumversion = false;
    String version = "1.1";

    public void onEnable() {
        boolean isWorldGuardEnabled;
        boolean isMythicMobsEnabled;
        this.plugin = this;
        this.eventManager = new EventManager();
        this.commandManager = new CommandManager();
        this.fileManager = new FileManager();
        this.fileManager.caricaFiles();
        this.commandManager.registerCommands();
        this.eventManager.registraEventi();
        File pluginFile = this.getFile();
        try {
            Class.forName("net.kyori.adventure.text.Component");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        try {
            JarFile jarFile = new JarFile(pluginFile);
            Manifest manifest = jarFile.getManifest();
            Attributes attributes = manifest.getMainAttributes();
            String isPremiumVersion = attributes.getValue("ispremiumversion");
            this.ispremiumversion = Boolean.parseBoolean(isPremiumVersion);
            jarFile.close();
        }
        catch (IOException e) {
            Logger.log(LogLevel.ERROR, "Something went wrong with the plugin.yml file." + e.getMessage());
        }
        if (this.ispremiumversion) {
            Logger.log(LogLevel.SUCCESS, "Avampost premium version enabled");
        } else {
            Logger.log(LogLevel.SUCCESS, "Avampost free version enabled");
        }
        int pluginId = 18487;
        try {
            Metrics metrics = new Metrics(this, pluginId);
            metrics.addCustomChart(new Metrics.SimplePie("is_premium", () -> String.valueOf(this.ispremiumversion)));
            metrics.addCustomChart(new Metrics.SimplePie("version", () -> this.version));
            Logger.log(LogLevel.SUCCESS, "Bstats Metrics loaded successfully.");
        }
        catch (Exception e) {
            Logger.log(LogLevel.ERROR, "Something went wrong with Bstats Metrics.");
            Logger.log(LogLevel.ERROR, e.getMessage());
        }
        Plugin mythicMobsPlugin = Bukkit.getPluginManager().getPlugin("MythicMobs");
        boolean bl = isMythicMobsEnabled = mythicMobsPlugin != null && mythicMobsPlugin.isEnabled();
        if (isMythicMobsEnabled) {
            Logger.log(LogLevel.SUCCESS, "MythicMobs found, enabling support");
        } else {
            Logger.log(LogLevel.ERROR, "MythicMobs not found, Please download it for proper functionality.");
        }
        Plugin worldGuardPlugin = Bukkit.getPluginManager().getPlugin("WorldGuard");
        boolean bl2 = isWorldGuardEnabled = worldGuardPlugin != null && worldGuardPlugin.isEnabled();
        if (isWorldGuardEnabled) {
            Logger.log(LogLevel.SUCCESS, "WorldGuard found, enabling support");
        } else {
            Logger.log(LogLevel.ERROR, "WorldGuard not found, Please download it for proper functionality.");
        }
        SessionManager sessionManager = WorldGuard.getInstance().getPlatform().getSessionManager();
        sessionManager.registerHandler((Handler.Factory)WGAvampostEntry.FACTORY, null);
        sessionManager.registerHandler((Handler.Factory)WGAvampost.FACTORY, null);
        this.avampostFileManager = new AvampostFileManager();
        this.avampostFileManager.consoleReload();
    }

    public void onDisable() {
        this.plugin = null;
    }

    public void onLoad() {
        FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
        try {
            BooleanFlag AVAMPOST_FLAG = new BooleanFlag("avampost-system", RegionGroup.ALL);
            StateFlag AVAMPOST_REQUIREMENTS_FLAG = new StateFlag("avampost-join-requirement", false);
            registry.register((Flag)AVAMPOST_FLAG);
            registry.register((Flag)AVAMPOST_REQUIREMENTS_FLAG);
            AVAMPOST_FLAG_ = AVAMPOST_FLAG;
            AVAMPOST_REQUIREMENTS_FLAG_ = AVAMPOST_REQUIREMENTS_FLAG;
        }
        catch (FlagConflictException e) {
            Logger.log(LogLevel.ERROR, "Something went wrong with the flag registry." + e.getMessage());
        }
    }

    public Boolean isPremiumVersion() {
        return this.ispremiumversion;
    }

    public ServerType getServerType() {
        try {
            Class.forName("com.destroystokyo.paper.PaperConfig");
            return ServerType.PAPER;
        }
        catch (ClassNotFoundException e) {
            return ServerType.SPIGOT;
        }
    }

    public static enum ServerType {
        PAPER,
        SPIGOT;

    }
}

