/*
 * Decompiled with CFR 0.152.
 */
package avampost.avampost;

import avampost.avampost.Checker;
import avampost.avampost.Main;
import avampost.avampost.paper.AvampostCommand;
import avampost.avampost.utility.LogLevel;
import avampost.avampost.utility.Logger;
import avampost.avampost.utility.Parser;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.bukkit.Location;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.entity.Player;

public class AvampostFileManager {
    private static final String AVAMPOSTI_SECTION = "avamposts";
    public Main plugin = (Main)Main.getPlugin(Main.class);

    public void check() {
        ConfigurationSection avampostiSection = AvampostCommand.avampostFile.getConfigurationSection(AVAMPOSTI_SECTION);
        if (avampostiSection == null) {
            Logger.log(LogLevel.WARNING, "Nessun avamposto trovato nel file di configurazione");
            return;
        }
        avampostiSection.getKeys(false).forEach(avampostoId -> {
            ConfigurationSection mobsSection;
            Location bossLocationSection;
            Logger.log(LogLevel.INFO, "<#AAA444>Checking avampost: " + avampostoId);
            ConfigurationSection avamposto = avampostiSection.getConfigurationSection(avampostoId);
            if (avamposto == null) {
                Logger.log(LogLevel.WARNING, "Avamposto " + avampostoId + " non valido");
                return;
            }
            AvampostFileManager.checkStringParam(avamposto, "region", "<green>region</green>");
            AvampostFileManager.checkStringParam(avamposto, "displayname", "<green>displayname</green>");
            AvampostFileManager.checkStringParam(avamposto, "description", "<green>description</green>");
            AvampostFileManager.checkStringParam(avamposto, "world", "<green>world</green>");
            AvampostFileManager.checkListParam(avamposto, "rewards", "<green>rewards</green>");
            ConfigurationSection bossSection = avamposto.getConfigurationSection("boss");
            if (bossSection != null) {
                AvampostFileManager.checkStringParam(bossSection, "id", "ID boss");
            }
            Location location = bossLocationSection = bossSection != null ? bossSection.getLocation("location") : null;
            if (bossLocationSection == null) {
                Logger.log(LogLevel.WARNING, "Avampost " + avampostoId + " without boss location");
            }
            if ((mobsSection = avamposto.getConfigurationSection("mobs")) == null) {
                Logger.log(LogLevel.WARNING, "Avampost: " + avampostoId + " without mobs section");
            } else {
                mobsSection.getKeys(false).forEach(mobId -> {
                    Logger.log(LogLevel.INFO, "Checking configuration of " + mobId + " of avampost: " + avampostoId);
                    ConfigurationSection mob = mobsSection.getConfigurationSection(mobId);
                    if (mob == null) {
                        Logger.log(LogLevel.WARNING, "Mob " + mobId + " of avampost " + avampostoId + " not valid");
                        return;
                    }
                    AvampostFileManager.checkStringParam(mob, "id", "<green>ID of mob: " + mobId + "</green>");
                    Location mobLocationSection = mob.getLocation("location");
                    if (mobLocationSection == null) {
                        Logger.log(LogLevel.WARNING, "Mob: " + mobId + " of avampost: " + avampostoId + " without Location");
                    }
                });
            }
            ConfigurationSection requirementsSection = avamposto.getConfigurationSection("requirements");
            if (requirementsSection == null) {
                Logger.log(LogLevel.WARNING, "Avampost: " + avampostoId + " without requirements section, generating it...");
                requirementsSection = avamposto.createSection("requirements");
                requirementsSection.set("requirements-to-join.enabled", (Object)false);
                requirementsSection.set("requirements-to-join.permission", (Object)"avampost.test");
                requirementsSection.set("requirements-to-start.enabled", (Object)false);
                requirementsSection.set("requirements-to-start.permission", (Object)"avampost.test");
                requirementsSection.set("requirements-to-get-rewards.enabled", (Object)false);
                requirementsSection.set("requirements-to-get-rewards.permission", (Object)"avampost.test");
                try {
                    AvampostCommand.avampostFile.save(new File(String.valueOf(this.plugin.getDataFolder()) + "/", "avampost.yml"));
                    Logger.log(LogLevel.SUCCESS, "Requirements section generated and file saved.");
                }
                catch (IOException e) {
                    Logger.log(LogLevel.ERROR, "Failed to save avampost.yml file." + e.getMessage());
                }
            } else {
                Logger.log(LogLevel.SUCCESS, "Requirements section found.");
            }
        });
    }

    public static void checkStringParam(ConfigurationSection section, String paramName, String paramDisplayName) {
        if (!section.contains(paramName)) {
            Logger.log(LogLevel.ERROR, "The parameter: " + paramDisplayName + " was not found in the section: " + section.getName());
        } else {
            String paramValue = section.getString(paramName);
            if (paramValue == null || paramValue.isEmpty()) {
                Logger.log(LogLevel.WARNING, "The parameter: " + paramDisplayName + " in the section: " + section.getName() + " its blank or null");
            }
        }
    }

    public static void checkListParam(ConfigurationSection section, String listName, String listDisplayName) {
        if (!section.contains(listName)) {
            Logger.log(LogLevel.WARNING, "List of: " + listDisplayName + " not founded in the section: " + section.getName());
        } else {
            List listValues = section.getStringList(listName);
            if (listValues.isEmpty()) {
                Logger.log(LogLevel.WARNING, "List of: " + listDisplayName + " in the section: " + section.getName() + " is empty or null");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvampostLocationValue(Player player, String avampostID, String action) {
        AvampostCommand.avampostFile.set("avamposts." + avampostID + "." + action, (Object)player.getLocation());
        try {
            player.sendMessage(Parser.parseKyori(AvampostCommand.messagesFile.getString("admin-config-message-set-value")));
            AvampostCommand.avampostFile.save(new File(String.valueOf(this.plugin.getDataFolder()) + "/", "avampost.yml"));
        }
        catch (IOException e) {
            player.sendMessage(Parser.parseKyori(AvampostCommand.messagesFile.getString("admin-config-message-set-error")));
            Logger.log(LogLevel.ERROR, "Failed to save avampost.yml file." + e.getMessage());
        }
        finally {
            Logger.log(LogLevel.SUCCESS, "Avampost location set.");
        }
    }

    public void consoleReload() {
        this.check();
        try {
            AvampostCommand.messagesFile.options().configuration().load(new File(String.valueOf(this.plugin.getDataFolder()) + "/", "messages.yml"));
            AvampostCommand.avampostFile.options().configuration().load(new File(String.valueOf(this.plugin.getDataFolder()) + "/", "avampost.yml"));
            this.plugin.reloadConfig();
            this.plugin.saveConfig();
            Checker checker = new Checker();
            checker.checkerMessages();
            Logger.log(LogLevel.INFO, "Reloaded File from console");
        }
        catch (IOException | InvalidConfigurationException e) {
            Logger.log(LogLevel.ERROR, "Error while reloading file from console");
            throw new RuntimeException(e);
        }
    }
}

