/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;

public final class ColourUtil {
    public static String colorize(String string) {
        if (string == null) {
            return null;
        }
        Pattern pattern = Pattern.compile("#[a-fA-F0-9]{6}");
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String color = string.substring(matcher.start(), matcher.end());
            string = string.replace(color, ChatColor.of((String)color) + "");
            matcher = pattern.matcher(string);
        }
        string = ChatColor.translateAlternateColorCodes((char)'&', (String)string);
        return string;
    }

    public static List<String> colouredLore(String ... lore) {
        return lore != null ? Arrays.stream(lore).map(ColourUtil::colorize).collect(Collectors.toList()) : new ArrayList<String>();
    }

    public static List<String> colouredLore(List<String> lore) {
        return lore != null ? lore.stream().filter(Objects::nonNull).map(ColourUtil::colorize).collect(Collectors.toList()) : new ArrayList<String>();
    }

    public static List<String> colouredLore(String lore) {
        String[] strings;
        ArrayList<String> list = new ArrayList<String>();
        for (String s : strings = lore.split("\n")) {
            list.add(ColourUtil.colorize(s));
        }
        return list;
    }

    private ColourUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

