/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.managers;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.TreeMap;
import me.dreamdevs.github.slender.SlenderMain;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final SlenderMain plugin;
    private final File configFolder;
    private final Map<String, Configuration> configs = new TreeMap<String, Configuration>(String.CASE_INSENSITIVE_ORDER);

    public ConfigManager(SlenderMain plugin) {
        this.plugin = plugin;
        this.configFolder = plugin.getDataFolder();
        if (!this.configFolder.exists()) {
            this.configFolder.mkdirs();
        }
    }

    public void loadConfigFile(String filename) {
        this.loadConfigFiles(filename);
    }

    public void loadConfigFiles(String ... filenames) {
        for (String filename : filenames) {
            File configFile = new File(this.configFolder, filename);
            try {
                if (!configFile.exists()) {
                    configFile.createNewFile();
                    InputStream in = this.plugin.getResource(filename);
                    if (in != null) {
                        try {
                            int len;
                            FileOutputStream out = new FileOutputStream(configFile);
                            byte[] buf = new byte[1024];
                            while ((len = in.read(buf)) > 0) {
                                ((OutputStream)out).write(buf, 0, len);
                            }
                            ((OutputStream)out).close();
                            in.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    } else {
                        this.plugin.getLogger().warning("Default configuration for " + filename + " missing");
                    }
                }
                Configuration config = new Configuration(configFile);
                config.load();
                this.configs.put(filename, config);
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
    }

    public void save(String filename) {
        if (this.configs.containsKey(filename)) {
            try {
                this.configs.get(filename).save();
            }
            catch (Exception e) {
                this.printException(e, filename);
            }
        }
    }

    public void reload(String filename) {
        if (this.configs.containsKey(filename)) {
            try {
                this.configs.get(filename).load();
            }
            catch (Exception e) {
                this.printException(e, filename);
            }
        }
    }

    public YamlConfiguration getConfig(String filename) {
        if (this.configs.containsKey(filename)) {
            return this.configs.get(filename).getConfig();
        }
        return null;
    }

    private void printException(Exception e, String filename) {
        if (e instanceof IOException) {
            this.plugin.getLogger().severe("I/O exception while handling " + filename);
        } else if (e instanceof InvalidConfigurationException) {
            this.plugin.getLogger().severe("Invalid configuration in " + filename);
        }
        e.printStackTrace();
    }

    public static class Configuration {
        private final File configFile;
        private YamlConfiguration config;

        public Configuration(File configFile) {
            this.configFile = configFile;
            this.config = new YamlConfiguration();
        }

        public YamlConfiguration getConfig() {
            return this.config;
        }

        public void load() throws IOException, InvalidConfigurationException {
            this.config.load(this.configFile);
        }

        public void save() throws IOException {
            this.config.save(this.configFile);
        }
    }
}

