/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.game.party;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import me.dreamdevs.github.slender.game.GamePlayer;
import me.dreamdevs.github.slender.game.party.PartyRole;
import me.dreamdevs.github.slender.utils.ColourUtil;

public class Party {
    private final Map<GamePlayer, PartyRole> members = new HashMap<GamePlayer, PartyRole>();
    private boolean open = true;
    private int maxPlayers = 4;

    public void sendMessage(String message) {
        this.members.keySet().forEach(gamePlayer -> gamePlayer.getPlayer().sendMessage(ColourUtil.colorize(message)));
    }

    public GamePlayer getLeader() {
        return this.members.entrySet().stream().filter(gamePlayerPartyRoleEntry -> gamePlayerPartyRoleEntry.getValue() == PartyRole.LEADER).map(Map.Entry::getKey).findFirst().orElse(null);
    }

    public List<GamePlayer> getMembersList() {
        return this.members.entrySet().stream().filter(entry -> ((PartyRole)((Object)((Object)entry.getValue()))).equals((Object)PartyRole.MEMBER)).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public Map<GamePlayer, PartyRole> getMembers() {
        return this.members;
    }

    public boolean isOpen() {
        return this.open;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setOpen(boolean open) {
        this.open = open;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }
}

