/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.game;

import java.io.File;
import java.io.IOException;
import me.dreamdevs.github.slender.SlenderMain;
import me.dreamdevs.github.slender.utils.ColourUtil;
import me.dreamdevs.github.slender.utils.Util;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class Lobby {
    private Location lobbyLocation;
    private File lobbyFile = new File(SlenderMain.getInstance().getDataFolder(), "lobby.yml");
    private FileConfiguration configuration;

    public Lobby() {
        Util.createFile(this.lobbyFile);
        this.configuration = YamlConfiguration.loadConfiguration((File)this.lobbyFile);
        if (this.configuration.isConfigurationSection("lobby")) {
            this.lobbyLocation = Util.getStringLocation(this.configuration.getConfigurationSection("lobby").getString("location"), true);
        }
    }

    public void teleportPlayerToLobby(Player player) {
        if (this.lobbyLocation != null) {
            player.teleport(this.lobbyLocation);
        } else {
            player.sendMessage(ColourUtil.colorize("&cLobby is not set!"));
        }
    }

    public void saveLobby(Player player) {
        this.lobbyLocation = player.getLocation().clone();
        try {
            this.configuration.set("lobby.location", (Object)Util.getLocationString(player.getLocation(), true));
            this.configuration.save(this.lobbyFile);
        }
        catch (IOException e) {
            Util.sendPluginMessage("&cSomething went wrong, could not save lobby location!");
        }
    }

    public Location getLobbyLocation() {
        return this.lobbyLocation;
    }

    public File getLobbyFile() {
        return this.lobbyFile;
    }

    public FileConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setLobbyLocation(Location lobbyLocation) {
        this.lobbyLocation = lobbyLocation;
    }

    public void setLobbyFile(File lobbyFile) {
        this.lobbyFile = lobbyFile;
    }

    public void setConfiguration(FileConfiguration configuration) {
        this.configuration = configuration;
    }
}

