/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.game;

import me.dreamdevs.github.slender.SlenderMain;
import me.dreamdevs.github.slender.game.Arena;
import me.dreamdevs.github.slender.game.perks.Perks;
import org.bukkit.entity.Player;

public class GamePlayer {
    private final Player player;
    private int wins;
    private int collectedPages;
    private int level;
    private int exp;
    private int killedSurvivors;
    private int killedSlenderMen;
    private boolean autoJoinMode;
    private boolean showArenaJoinMessage;
    private String messagesType;
    private Perks equippedSurvivorPerk;
    private Perks equippedSlenderManPerk;

    public GamePlayer(Player player) {
        this.player = player;
    }

    public void clearInventory() {
        this.player.getInventory().clear();
        this.player.getInventory().setArmorContents(null);
        this.player.getInventory().setExtraContents(null);
    }

    public boolean isInArena() {
        return this.getArena() != null;
    }

    public Arena getArena() {
        return SlenderMain.getInstance().getGameManager().getArenas().stream().filter(arena -> arena.getPlayers().containsKey(this.player)).findFirst().orElse(null);
    }

    public void setWins(int wins) {
        this.wins = wins;
    }

    public void setCollectedPages(int collectedPages) {
        this.collectedPages = collectedPages;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setExp(int exp) {
        this.exp = exp;
    }

    public void setKilledSurvivors(int killedSurvivors) {
        this.killedSurvivors = killedSurvivors;
    }

    public void setKilledSlenderMen(int killedSlenderMen) {
        this.killedSlenderMen = killedSlenderMen;
    }

    public void setAutoJoinMode(boolean autoJoinMode) {
        this.autoJoinMode = autoJoinMode;
    }

    public void setShowArenaJoinMessage(boolean showArenaJoinMessage) {
        this.showArenaJoinMessage = showArenaJoinMessage;
    }

    public void setMessagesType(String messagesType) {
        this.messagesType = messagesType;
    }

    public void setEquippedSurvivorPerk(Perks equippedSurvivorPerk) {
        this.equippedSurvivorPerk = equippedSurvivorPerk;
    }

    public void setEquippedSlenderManPerk(Perks equippedSlenderManPerk) {
        this.equippedSlenderManPerk = equippedSlenderManPerk;
    }

    public Player getPlayer() {
        return this.player;
    }

    public int getWins() {
        return this.wins;
    }

    public int getCollectedPages() {
        return this.collectedPages;
    }

    public int getLevel() {
        return this.level;
    }

    public int getExp() {
        return this.exp;
    }

    public int getKilledSurvivors() {
        return this.killedSurvivors;
    }

    public int getKilledSlenderMen() {
        return this.killedSlenderMen;
    }

    public boolean isAutoJoinMode() {
        return this.autoJoinMode;
    }

    public boolean isShowArenaJoinMessage() {
        return this.showArenaJoinMessage;
    }

    public String getMessagesType() {
        return this.messagesType;
    }

    public Perks getEquippedSurvivorPerk() {
        return this.equippedSurvivorPerk;
    }

    public Perks getEquippedSlenderManPerk() {
        return this.equippedSlenderManPerk;
    }
}

