/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.game;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import me.dreamdevs.github.slender.SlenderMain;
import me.dreamdevs.github.slender.api.events.SlenderGameEndEvent;
import me.dreamdevs.github.slender.api.events.SlenderGameStartEvent;
import me.dreamdevs.github.slender.game.ArenaState;
import me.dreamdevs.github.slender.game.GamePlayer;
import me.dreamdevs.github.slender.game.Role;
import me.dreamdevs.github.slender.utils.ColourUtil;
import me.dreamdevs.github.slender.utils.CustomItem;
import me.dreamdevs.github.slender.utils.Util;
import me.libraryaddict.disguise.DisguiseAPI;
import me.libraryaddict.disguise.disguisetypes.Disguise;
import me.libraryaddict.disguise.disguisetypes.DisguiseType;
import me.libraryaddict.disguise.disguisetypes.MobDisguise;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.attribute.Attribute;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;

public class Arena
extends BukkitRunnable {
    private String id;
    private int minPlayers;
    private int maxPlayers;
    private int gameTime;
    private int timer;
    private Location slenderSpawnLocation;
    private List<Location> survivorsLocations;
    private List<Location> pagesLocations;
    private ArenaState arenaState;
    private Map<Player, Role> players;
    private Player slenderMan;
    private BossBar bossBar;
    private int collectedPages;
    private Scoreboard scoreboard;
    private Objective objective;
    private File file;

    public Arena(String id) {
        this.id = id;
        this.arenaState = ArenaState.WAITING;
        this.players = new ConcurrentHashMap<Player, Role>();
        this.survivorsLocations = new ArrayList<Location>();
        this.pagesLocations = new ArrayList<Location>();
        this.bossBar = Bukkit.createBossBar((String)SlenderMain.getInstance().getMessagesManager().getMessage("arena-boss-bar-waiting"), (BarColor)BarColor.RED, (BarStyle)BarStyle.SOLID, (BarFlag[])new BarFlag[]{BarFlag.DARKEN_SKY});
        this.slenderMan = null;
        this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        this.scoreboard.registerNewObjective(id, "dummy", id);
        this.scoreboard.registerNewTeam("survivors");
        this.scoreboard.registerNewTeam("slenderman");
        this.scoreboard.getTeam("survivors").setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
        this.scoreboard.getTeam("slenderman").setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
    }

    public void startGame() {
        this.runTaskTimer((Plugin)SlenderMain.getInstance(), 20L, 20L);
    }

    public void run() {
        if (this.arenaState == ArenaState.WAITING) {
            if (this.players.isEmpty()) {
                return;
            }
            this.sendTitleToAllPlayers("", SlenderMain.getInstance().getMessagesManager().getMessage("arena-waiting-subtitle"), 0, 25, 25);
            return;
        }
        if (this.arenaState == ArenaState.STARTING) {
            this.sendTitleToAllPlayers("", SlenderMain.getInstance().getMessagesManager().getMessage("arena-starting-subtitle").replaceAll("%TIME%", String.valueOf(this.timer)), 0, 25, 25);
            if (this.timer == 0) {
                this.start();
                return;
            }
            --this.timer;
        }
        if (this.arenaState == ArenaState.RUNNING) {
            this.bossBar.setTitle(SlenderMain.getInstance().getMessagesManager().getMessage("arena-boss-bar-time-left").replaceAll("%TIME%", String.valueOf(this.timer)));
            this.sendActionBar(SlenderMain.getInstance().getMessagesManager().getMessage("arena-collected-pages").replaceAll("%CURRENT%", Integer.toString(this.collectedPages)));
            if (this.timer == 0) {
                this.endGame();
                return;
            }
            --this.timer;
        }
        if (this.arenaState == ArenaState.ENDING) {
            this.bossBar.setTitle(SlenderMain.getInstance().getMessagesManager().getMessage("arena-boss-bar-teleport-to-lobby").replaceAll("%TIME%", String.valueOf(this.timer)));
            if (this.timer == 0) {
                this.restart();
                return;
            }
            --this.timer;
        }
        if (this.arenaState == ArenaState.RESTARTING) {
            Bukkit.getWorlds().forEach(world -> world.getEntities().stream().filter(Item.class::isInstance).forEach(Entity::remove));
            this.bossBar.setTitle(SlenderMain.getInstance().getMessagesManager().getMessage("arena-boss-bar-waiting"));
            this.scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
            this.scoreboard.registerNewObjective(this.id, "dummy", this.id);
            this.scoreboard.registerNewTeam("survivors");
            this.scoreboard.registerNewTeam("slenderman");
            this.slenderMan = null;
            Bukkit.getScheduler().runTaskLater((Plugin)SlenderMain.getInstance(), () -> this.setArenaState(ArenaState.WAITING), 100L);
        }
    }

    public void start() {
        this.bossBar.setTitle(ColourUtil.colorize(SlenderMain.getInstance().getMessagesManager().getMessage("arena-boss-bar-time-left").replaceAll("%TIME%", String.valueOf(this.timer))));
        this.sendTitleToAllPlayers(SlenderMain.getInstance().getMessagesManager().getMessage("arena-title"), SlenderMain.getInstance().getMessagesManager().getMessage("arena-started-subtitle"), 10, 30, 10);
        this.sendPlayersToGame();
        this.setArenaState(ArenaState.RUNNING);
        this.setTimer(this.gameTime);
        this.spawnPage();
        SlenderGameStartEvent slenderGameStartEvent = new SlenderGameStartEvent(this);
        Bukkit.getPluginManager().callEvent((Event)slenderGameStartEvent);
    }

    private void sendPlayersToGame() {
        ArrayList<Player> tempList = new ArrayList<Player>(this.players.keySet());
        int size = tempList.size();
        int random = Util.getRandomNumber(size);
        this.slenderMan = (Player)tempList.get(random);
        tempList.remove(this.slenderMan);
        tempList.forEach(player -> this.players.put((Player)player, Role.SURVIVOR));
        this.players.put(this.slenderMan, Role.SLENDER);
        this.slenderMan.getScoreboard().getTeam("slenderman").addPlayer((OfflinePlayer)this.slenderMan);
        this.slenderMan.getInventory().clear();
        this.slenderMan.getInventory().setItem(0, CustomItem.SLENDERMAN_WEAPON.toItemStack());
        this.slenderMan.getInventory().setItem(1, CustomItem.SLENDERMAN_COMPASS.toItemStack());
        tempList.forEach(player -> {
            player.teleport(this.survivorsLocations.get(Util.getRandomNumber(this.survivorsLocations.size())));
            player.getScoreboard().getTeam("survivors").addPlayer((OfflinePlayer)player);
            player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, Integer.MAX_VALUE, Integer.MAX_VALUE));
            player.getInventory().clear();
            player.getInventory().setItem(0, CustomItem.SURVIVOR_WEAPON.toItemStack());
            player.getInventory().setItem(1, new ItemStack(Material.TORCH, 3));
        });
        this.slenderMan.teleport(this.slenderSpawnLocation);
        this.slenderMan.getAttribute(Attribute.GENERIC_MAX_HEALTH).setBaseValue(40.0);
        this.slenderMan.setHealth(40.0);
        this.slenderMan.addPotionEffect(new PotionEffect(PotionEffectType.NIGHT_VISION, Integer.MAX_VALUE, Integer.MAX_VALUE));
        if (SlenderMain.getInstance().isUseLibsDisguises()) {
            DisguiseAPI.disguiseToAll((Entity)this.slenderMan, (Disguise)new MobDisguise(DisguiseType.ENDERMAN));
            DisguiseAPI.setActionBarShown((Player)this.slenderMan, (boolean)false);
            DisguiseAPI.setViewDisguiseToggled((Entity)this.slenderMan, (boolean)false);
        }
    }

    private void sendTitleToAllPlayers(String title, String subTitle, int fadeIn, int stayIn, int fadeOut) {
        this.players.keySet().forEach(player -> player.sendTitle(ColourUtil.colorize(title), ColourUtil.colorize(subTitle), fadeIn, stayIn, fadeOut));
    }

    private void sendActionBar(String message) {
        this.players.keySet().forEach(player -> player.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)new TextComponent(ColourUtil.colorize(message))));
    }

    public void restart() {
        Bukkit.getWorlds().forEach(world -> world.getEntities().stream().filter(Item.class::isInstance).forEach(Entity::remove));
        SlenderMain.getInstance().getPlayerManager().getPlayers().stream().filter(gamePlayer -> gamePlayer.isInArena() && ((Object)((Object)gamePlayer.getArena())).equals((Object)this) && gamePlayer.isAutoJoinMode()).forEach(gamePlayer -> {
            SlenderMain.getInstance().getGameManager().leaveGame(gamePlayer.getPlayer(), this);
            Arena arena = SlenderMain.getInstance().getGameManager().getAvailableArena();
            if (arena == null) {
                gamePlayer.getPlayer().sendMessage(SlenderMain.getInstance().getMessagesManager().getMessage("no-available-arenas"));
                return;
            }
            SlenderMain.getInstance().getGameManager().joinGame(gamePlayer.getPlayer(), arena);
        });
        this.players.keySet().forEach(player -> {
            player.sendMessage(ColourUtil.colorize(SlenderMain.getInstance().getMessagesManager().getMessage("arena-game-stopped")));
            SlenderMain.getInstance().getGameManager().leaveGame((Player)player, this);
        });
        this.setArenaState(ArenaState.RESTARTING);
        this.scoreboard = null;
        this.players.clear();
        this.setCollectedPages(0);
    }

    public void endGame() {
        this.bossBar.setTitle(SlenderMain.getInstance().getMessagesManager().getMessage("arena-boss-bar-teleport-to-lobby").replaceAll("%TIME%", String.valueOf(this.timer)));
        if (this.getCollectedPages() < 8) {
            this.sendTitleToAllPlayers(SlenderMain.getInstance().getMessagesManager().getMessage("arena-title"), SlenderMain.getInstance().getMessagesManager().getMessage("arena-slenderman-win-subtitle"), 10, 50, 10);
            GamePlayer gamePlayer = SlenderMain.getInstance().getPlayerManager().getPlayer(this.slenderMan);
            gamePlayer.setWins(gamePlayer.getWins() + 1);
        } else {
            this.sendTitleToAllPlayers(SlenderMain.getInstance().getMessagesManager().getMessage("arena-title"), SlenderMain.getInstance().getMessagesManager().getMessage("arena-survivors-win-subtitle"), 10, 50, 10);
            this.getPlayers().entrySet().stream().filter(playerRoleEntry -> playerRoleEntry.getValue() == Role.SURVIVOR).forEach(playerRoleEntry -> {
                GamePlayer gamePlayer = SlenderMain.getInstance().getPlayerManager().getPlayer((Player)playerRoleEntry.getKey());
                gamePlayer.setWins(gamePlayer.getWins() + 1);
            });
        }
        this.getPlayers().keySet().forEach(player -> {
            this.getPlayers().put((Player)player, Role.NONE);
            player.getInventory().clear();
            player.getActivePotionEffects().stream().map(PotionEffect::getType).forEach(arg_0 -> ((Player)player).removePotionEffect(arg_0));
            player.getInventory().setItem(7, CustomItem.PLAY_AGAIN.toItemStack());
            player.getInventory().setItem(8, CustomItem.LEAVE.toItemStack());
        });
        this.setArenaState(ArenaState.ENDING);
        this.setTimer(15);
        SlenderGameEndEvent slenderGameEndEvent = new SlenderGameEndEvent(this);
        Bukkit.getPluginManager().callEvent((Event)slenderGameEndEvent);
    }

    public void spawnPage() {
        ItemStack itemStack = new ItemStack(Material.PAPER);
        Item item = this.slenderSpawnLocation.getWorld().dropItem(this.getPagesLocations().get(Util.getRandomNumber(this.getPagesLocations().size())), itemStack);
        item.setCustomName(SlenderMain.getInstance().getMessagesManager().getMessage("arena-page-name").replaceAll("%NUMBER%", String.valueOf(this.collectedPages + 1)));
        item.setCustomNameVisible(true);
        this.sendMessage(SlenderMain.getInstance().getMessagesManager().getMessage("arena-page-spawned-announcement"));
    }

    public int getSurvivorsAmount() {
        return this.players.entrySet().stream().filter(playerRoleEntry -> playerRoleEntry.getValue() == Role.SURVIVOR).collect(Collectors.toList()).size();
    }

    public void sendMessage(String message) {
        this.players.keySet().forEach(player -> player.sendMessage(ColourUtil.colorize(message)));
    }

    public boolean isRunning() {
        return this.getArenaState() == ArenaState.RUNNING || this.getArenaState() == ArenaState.ENDING;
    }

    public String getId() {
        return this.id;
    }

    public int getMinPlayers() {
        return this.minPlayers;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public int getGameTime() {
        return this.gameTime;
    }

    public int getTimer() {
        return this.timer;
    }

    public Location getSlenderSpawnLocation() {
        return this.slenderSpawnLocation;
    }

    public List<Location> getSurvivorsLocations() {
        return this.survivorsLocations;
    }

    public List<Location> getPagesLocations() {
        return this.pagesLocations;
    }

    public ArenaState getArenaState() {
        return this.arenaState;
    }

    public Map<Player, Role> getPlayers() {
        return this.players;
    }

    public Player getSlenderMan() {
        return this.slenderMan;
    }

    public BossBar getBossBar() {
        return this.bossBar;
    }

    public int getCollectedPages() {
        return this.collectedPages;
    }

    public Scoreboard getScoreboard() {
        return this.scoreboard;
    }

    public Objective getObjective() {
        return this.objective;
    }

    public File getFile() {
        return this.file;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setMinPlayers(int minPlayers) {
        this.minPlayers = minPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setGameTime(int gameTime) {
        this.gameTime = gameTime;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public void setSlenderSpawnLocation(Location slenderSpawnLocation) {
        this.slenderSpawnLocation = slenderSpawnLocation;
    }

    public void setSurvivorsLocations(List<Location> survivorsLocations) {
        this.survivorsLocations = survivorsLocations;
    }

    public void setPagesLocations(List<Location> pagesLocations) {
        this.pagesLocations = pagesLocations;
    }

    public void setArenaState(ArenaState arenaState) {
        this.arenaState = arenaState;
    }

    public void setPlayers(Map<Player, Role> players) {
        this.players = players;
    }

    public void setSlenderMan(Player slenderMan) {
        this.slenderMan = slenderMan;
    }

    public void setBossBar(BossBar bossBar) {
        this.bossBar = bossBar;
    }

    public void setCollectedPages(int collectedPages) {
        this.collectedPages = collectedPages;
    }

    public void setScoreboard(Scoreboard scoreboard) {
        this.scoreboard = scoreboard;
    }

    public void setObjective(Objective objective) {
        this.objective = objective;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

