/*
 * Decompiled with CFR 0.152.
 */
package me.dreamdevs.github.slender.database;

import java.io.File;
import me.dreamdevs.github.slender.SlenderMain;
import me.dreamdevs.github.slender.api.database.IData;
import me.dreamdevs.github.slender.game.GamePlayer;
import me.dreamdevs.github.slender.game.perks.Perks;
import me.dreamdevs.github.slender.utils.Util;
import org.bukkit.configuration.file.YamlConfiguration;

public class DatabaseYAML
implements IData {
    private File dataDirectory;

    @Override
    public void connectDatabase() {
        this.dataDirectory = new File(SlenderMain.getInstance().getDataFolder(), "users");
        if (!this.dataDirectory.exists() || !this.dataDirectory.isDirectory()) {
            this.dataDirectory.mkdirs();
        }
    }

    @Override
    public void disconnectDatabase() {
    }

    @Override
    public void saveAllStatistics(GamePlayer gamePlayer) {
        File playerFile = new File(this.dataDirectory, gamePlayer.getPlayer().getUniqueId() + ".yml");
        Util.createFile(playerFile);
        YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
        playerData.set("PlayerInfo.UUID", (Object)gamePlayer.getPlayer().getUniqueId().toString());
        playerData.set("PlayerInfo.Nick", (Object)gamePlayer.getPlayer().getName());
        playerData.set("Statistics.Wins", (Object)gamePlayer.getWins());
        playerData.set("Statistics.CollectedPages", (Object)gamePlayer.getCollectedPages());
        playerData.set("Statistics.Level", (Object)gamePlayer.getLevel());
        playerData.set("Statistics.Exp", (Object)gamePlayer.getExp());
        playerData.set("Statistics.KilledSurvivors", (Object)gamePlayer.getKilledSurvivors());
        playerData.set("Statistics.KilledSlenderMen", (Object)gamePlayer.getKilledSlenderMen());
        playerData.set("PlayerSettings.AutoArenaJoin", (Object)gamePlayer.isAutoJoinMode());
        playerData.set("PlayerSettings.ShowJoinArenaMessage", (Object)gamePlayer.isShowArenaJoinMessage());
        playerData.set("PlayerSettings.MessagesType", (Object)gamePlayer.getMessagesType());
        playerData.set("PlayerPerks.EquippedSurvivorPerk", (Object)gamePlayer.getEquippedSurvivorPerk().name());
        playerData.set("PlayerPerks.EquippedSlenderManPerk", (Object)gamePlayer.getEquippedSlenderManPerk().name());
        try {
            playerData.save(playerFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void loadAllStatistics(GamePlayer gamePlayer) {
        File playerFile = new File(this.dataDirectory, gamePlayer.getPlayer().getUniqueId() + ".yml");
        Util.createFile(playerFile);
        YamlConfiguration playerData = YamlConfiguration.loadConfiguration((File)playerFile);
        gamePlayer.setWins(playerData.getInt("Statistics.Wins", 0));
        gamePlayer.setLevel(playerData.getInt("Statistics.Level", 0));
        gamePlayer.setCollectedPages(playerData.getInt("Statistics.CollectedPages", 0));
        gamePlayer.setExp(playerData.getInt("Statistics.Exp", 0));
        gamePlayer.setKilledSlenderMen(playerData.getInt("Statistics.KilledSlenderMen", 0));
        gamePlayer.setKilledSurvivors(playerData.getInt("Statistics.KilledSurvivors", 0));
        gamePlayer.setAutoJoinMode(playerData.getBoolean("PlayerSettings.AutoArenaJoin", false));
        gamePlayer.setShowArenaJoinMessage(playerData.getBoolean("PlayerSettings.ShowJoinArenaMessage", true));
        gamePlayer.setMessagesType(playerData.getString("PlayerSettings.MessagesType", "all"));
        gamePlayer.setEquippedSurvivorPerk(Perks.valueOf(playerData.getString("PlayerPerks.EquippedSurvivorPerk", "NONE")));
        gamePlayer.setEquippedSlenderManPerk(Perks.valueOf(playerData.getString("PlayerPerks.EquippedSlenderManPerk", "NONE")));
    }
}

